% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barrier.R
\name{calculate_barrier_3d}
\alias{calculate_barrier_3d}
\title{Calculate barrier from a 3D landscape}
\usage{
calculate_barrier_3d(
  l,
  start_location_value = c(0, 0),
  start_r = 0.1,
  end_location_value = c(0.7, 0.6),
  end_r = 0.15,
  Umax,
  expand = TRUE,
  omit_unstable = FALSE,
  base = exp(1)
)
}
\arguments{
\item{l}{A \code{3d_static_landscape} object (recommended) or a \code{kde2d} distribution.}

\item{start_location_value, end_location_value}{The initial position (in value) for searching the start/end point.}

\item{start_r, end_r}{The searching (L1) radius for searching the start/end point.}

\item{Umax}{The highest possible value of the potential function.}

\item{expand}{If the values in the range all equal to \code{Umax}, expand the range or not?}

\item{omit_unstable}{If a state is not stable (the "local minimum" overlaps with the saddle point), omit that state or not?}

\item{base}{The base of the log function.}
}
\description{
Calculate barrier from a 3D landscape
}
