% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/targetparam.r
\name{eval.target}
\alias{eval.target}
\title{Evaluate the Causal Target Parameter via Monte-Carlo Simulation}
\usage{
eval.target(DAG, n, data, actions, rndseed = NULL)
}
\arguments{
\item{DAG}{DAG object with target parameter set via \code{set.targetE} or \code{set.targetMSM} functions}

\item{n}{Number of observations to simulate (if simulating full data), this is overwritten by the number of observations in each data}

\item{data}{List of action-specific \code{data.frames} generated with \code{sim} or \code{simfull}}

\item{actions}{Character vector of action names which play the role of the data generating mechanism for simulated data when argument \code{data} is missing. Alternatively, \code{actions} can be a list of action DAGs  pre-selected with \code{A(DAG)} function. When this argument is missing, full data is automatically sampled from all available actions in the \code{DAG} argument.}

\item{rndseed}{Seed for the random number generator.}
}
\value{
For targetE returns a vector of counterfactual means, ATE or ATR; for targetMSM returns a named list with the MSM model fit (\code{"msm"}),
MSM model coefficients (\code{"coef"}), the mapping of the MSM summary terms \code{S()} to the actual variable names used in the data, (\code{"S.msm.map"}),
and the long format full data that was used for fitting this MSM \code{"df_long"}.
}
\description{
This function estimates the true value of the previously set target parameter (\code{set.targetE} or \code{set.targetMSM}) using the DAG object and either 1) \code{data}: list of action-specific simulated \code{data.frames}; or 2) \code{actions}; or 3) when \code{data} and \code{actions} are missing, using all distinct actions previously defined on the \code{DAG} object.
}
\details{
For examples and additional details see documentation for \code{\link{set.targetE}} or \code{\link{set.targetMSM}}
}

