% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep.R
\name{eval_sites}
\alias{eval_sites}
\title{Evaluate sites.}
\usage{
eval_sites(df_sim_sites, method = "BH", under_only = TRUE, ...)
}
\arguments{
\item{df_sim_sites}{dataframe generated by \code{\link[simaerep]{sim_sites}}}

\item{method}{character, passed to stats::p.adjust(), if NULL
eval_sites_deprecated() is used instead, Default = "BH"}

\item{under_only}{compute under-reporting probabilities only, default = TRUE
\link[=check_df_visit]{check_df_visit()}, computationally expensive on large data
sets. Default: TRUE}

\item{...}{use to pass r_sim_sites parameter to eval_sites_deprecated()}
}
\value{
dataframe with the following columns:
\describe{
\item{\strong{study_id}}{study identification}
\item{\strong{site_number}}{site identification}
\item{\strong{visit_med75}}{median(max(visit)) * 0.75}
\item{\strong{mean_ae_site_med75}}{mean AE at visit_med75 site level}
\item{\strong{mean_ae_study_med75}}{mean AE at visit_med75 study level}
\item{\strong{pval}}{p-value as returned by \code{\link[stats]{poisson.test}}}
\item{\strong{prob_low}}{bootstrapped probability for having mean_ae_site_med75 or lower}
\item{\strong{pval_adj}}{adjusted p-values}
\item{\strong{prob_low_adj}}{adjusted bootstrapped probability for having mean_ae_site_med75 or lower}
\item{\strong{pval_prob_ur}}{probability under-reporting as 1 - pval_adj, poisson.test (use as benchmark)}
\item{\strong{prob_low_prob_ur}}{probability under-reporting as 1 - prob_low_adj, bootstrapped (use)}

}
}
\description{
Correct under-reporting probabilities using  \code{\link[stats]{p.adjust}}.
}
\examples{
df_visit <- sim_test_data_study(n_pat = 100, n_sites = 5,
    frac_site_with_ur = 0.4, ur_rate = 0.6)

df_visit$study_id <- "A"
df_site <- site_aggr(df_visit)

df_sim_sites <- sim_sites(df_site, df_visit, r = 100)

df_eval <- eval_sites(df_sim_sites)
df_eval

}
\seealso{
\code{\link[simaerep]{site_aggr}},
\code{\link[simaerep]{sim_sites}},
\code{\link[stats]{p.adjust}}
}
