% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/simGG.simlinear.R
\name{simGG.simlinear}
\alias{simGG.simlinear}
\title{Plot simulated linear, non-time interacted quantities of interest from Cox
Proportional Hazards Models}
\usage{
\method{simGG}{simlinear}(obj, from = NULL, to = NULL, rug = TRUE,
  rug_position = "identity", xlab = NULL, ylab = NULL, title = NULL,
  method = "auto", spalette = "Set1", legend = "legend", leg.name = "",
  lcolour = "#2B8CBE", lsize = 1, pcolour = "#A6CEE3", psize = 1,
  alpha = 0.2, type = "ribbons", ...)
}
\arguments{
\item{obj}{a \code{simlinear} class object.}

\item{from}{numeric time to start the plot from. Only relevant if
\code{qi = "Hazard Rate"}.}

\item{to}{numeric time to plot to. Only relevant if
\code{qi = "Hazard Rate"}.}

\item{rug}{logical indicating whether or not to include a rug plot showing
the distribution of values in the sample used to estimate the \code{coxph}
model. Only relevant when the quantity of interest is not
\code{"Hazard Rate"}.}

\item{rug_position}{character string. The position adjustment to use for
overlapping points in the rug plot. Use \code{"jitter"} to jitter the points.}

\item{xlab}{a label for the plot's x-axis.}

\item{ylab}{a label of the plot's y-axis. The default uses the value of
\code{qi}.}

\item{title}{the plot's main title.}

\item{method}{what type of smoothing method to use to summarize the center
of the simulation distribution.}

\item{spalette}{colour palette for when there are multiple sets of
comparisons to plot. Default palette is \code{"Set1"}. See
\code{\link{scale_colour_brewer}}.}

\item{legend}{specifies what type of legend to include (if applicable).
The default is \code{legend = "legend"}. To hide the legend use
\code{legend = FALSE}. See the \code{\link{discrete_scale}} for more details.}

\item{leg.name}{name of the legend (if applicable).}

\item{lcolour}{character string colour of the smoothing line. The default is
hexadecimal colour \code{lcolour = '#2B8CBE'}. Only relevant if
\code{qi = "First Difference"}.}

\item{lsize}{size of the smoothing line. Default is 1. See
\code{\link{ggplot2}}.}

\item{pcolour}{character string colour of the simulated points or ribbons
(when there are not multiple sets of simulations). Default is hexadecimal
colour \code{pcolour = '#A6CEE3'}.}

\item{psize}{size of the plotted simulation points. Default is
\code{psize = 1}. See \code{\link{ggplot2}}.}

\item{alpha}{numeric. Alpha (e.g. transparency) for the points, lines, or
ribbons. Default is \code{alpha = 0.2}. See \code{\link{ggplot2}}. Note, if
\code{type = "lines"} or \code{type = "points"} then \code{alpah} sets the
maximum value per line or point at the center of the distribution. Lines or
points further from the center are more transparent the further they get from
the middle.}

\item{type}{character string. Specifies how to plot the simulations. Can be
\code{points}, \code{lines}, or \code{ribbons}. If points then each
simulation value will be plotted. If \code{lines} is chosen then each
simulation is plotted using a different line. Note: any simulation with a
value along its length that is outside of the specified central interval will
be dropped. This is to create a smooth plot. If \code{type = "ribbons"} a
plot will be created with shaded areas ('ribbons') for the minimum and
maximum simulation values (i.e. the middle interval set with \code{qi} in
\code{\link{coxsimSpline}}) as well as the central 50 percent of this area.
It also plots a line for the median value of the full area, so values in
\code{method} are ignored. One of the key advantages of using ribbons
rather than points is that it creates plots with smaller file sizes.}

\item{...}{Additional arguments. (Currently ignored.)}
}
\value{
a \code{gg} \code{ggplot} class object
}
\description{
\code{simGG.simlinear} uses \link{ggplot2} to plot the quantities of interest
 from \code{simlinear} objects, including relative hazards, first
differences, hazard ratios, and hazard rates.
}
\details{
Uses \link{ggplot2} to plot the quantities of interest from
\code{simlinear} objects, including relative hazards, first differences,
hazard ratios, and hazard rates. If there are multiple strata, the
quantities of interest will be plotted in a grid by strata.
Note: A dotted line is created at y = 1 (0 for first difference), i.e. no
effect, for time-varying hazard ratio graphs. No line is created for hazard
rates.
}
\examples{
# Load survival package
library(survival)
# Load Carpenter (2002) data
data("CarpenterFdaData")

# Estimate basic model
M1 <- coxph(Surv(acttime, censor) ~ prevgenx + lethal +
            deathrt1 + acutediz + hosp01  + hhosleng +
            mandiz01 + femdiz01 + peddiz01 + orphdum +
            vandavg3 + wpnoavg3 + condavg3 + orderent +
            stafcder, data = CarpenterFdaData)

# Simulate and plot Hazard Ratios for stafcder variable
Sim1 <- coxsimLinear(M1, b = "stafcder",
                     Xj = c(1237, 1600),
                     Xl = c(1000, 1000),
                     qi = "Hazard Ratio",
                     spin = TRUE, ci = 0.99)
simGG(Sim1, method = 'lm', rug_position = 'jitter')
simGG(Sim1, rug_position = 'jitter')

\dontrun{
# Simulate and plot Hazard Rate for stafcder variable
Sim2 <- coxsimLinear(M1, b = "stafcder", nsim = 100,
                      qi = "Hazard Rate",
                      Xj = c(1237, 1600))
simGG(Sim2, type = 'points')
simGG(Sim2, type = 'lines')
}
}
\references{
Licht, Amanda A. 2011. ''Change Comes with Time: Substantive
Interpretation of Nonproportional Hazards in Event History Analysis.''
Political Analysis 19: 227-43.

Keele, Luke. 2010. ''Proportionally Difficult: Testing for Nonproportional
Hazards in Cox Models.'' Political Analysis 18(2): 189-205.

Carpenter, Daniel P. 2002. ''Groups, the Media, Agency Waiting Costs, and
FDA Drug Approval.'' American Journal of Political Science 46(3): 490-505.
}
\seealso{
\code{\link{coxsimLinear}}, \code{\link{simGG.simtvc}}, and
\code{\link{ggplot2}}
}

