#' Simulation of Fatigue Lifetimes
#'
#' Provides methods for simulation and analysis of a very general fatigue
#' lifetime model for (metal matrix) composite materials.
#' 
#' These materials are usually made up of some reinforcement primary phase and a secondary
#' phase which is generally considered to have negative properties with regard to the overall
#' lifetime. A spatial geometric particle model can be simulated according to some predefined
#' distributional assumptions and then taken as an input to the simulation routine of the fatigue
#' lifetime model. The distributional model parameters of the lifetime model are specified by the
#' user and usually have to be estimated based on experimental data in general.  
#' The lifetime model roughly consists of two parts.
#' First, a random individual failure time for all particles is generated based on
#' two types of projected defects (square root projection areas) dependent on the considered 
#' joint size-shape-orientation distribution of the whole particle system. Second, a deterministic
#' projected defects accumulation procedure is applied to find the most hazardous defect
#' region which could lead to an overall failure of the specimen in a real life situation. 
#' Additionally we distinguish between particles which are hosted fully inside the material
#' and those lying near the surface. Further, the lifetime model also allows for the inclusion 
#' of predefined densely clustered regions of particles which can be simulated beforehand.
#' The user can also provide particular material constants such as Vickers hardness and others 
#' according to the phenomenological properties of specific material structures and for 
#' appropriateness of the lifetime model simulations. As an add-on hardcore particle packings
#' can be generated by the well-known Random Sequential Adsorption (RSA) algorithm.
#' 
#' @references
#' \itemize{
#'   \item Y. Murakami (2002). Metal Fatigue: Effects of Small Defects and Nonmetallic Inclusions. Elsevier, Amsterdam.
#'   \item J.W. Evans. Random and cooperative sequential adsorption. Rev. Mod. Phys., 65: 1281-1304, 1993.
#' }
#'  
#' @section :
#' The high level functions \code{\link{simFracture}}, \code{\link{woehler}} and
#' \code{\link{woehlerDiagram}} are intended as a simple introduction to utilizing the package.
#'
#' @docType package
#' @seealso \code{\link[unfoldr]{unfold}}
#' @name simLife-package
NULL
