% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_sig_bootstrap.R
\name{show_sig_bootstrap}
\alias{show_sig_bootstrap}
\alias{show_sig_bootstrap_exposure}
\alias{show_sig_bootstrap_error}
\alias{show_sig_bootstrap_stability}
\title{Show Signature Bootstrap Analysis Results}
\usage{
show_sig_bootstrap_exposure(
  bt_result,
  sample = NULL,
  signatures = NULL,
  methods = "LS",
  palette = "aaas",
  title = NULL,
  xlab = FALSE,
  ylab = "Signature exposure",
  width = 0.3,
  dodge_width = 0.8,
  outlier.shape = NA,
  add = "jitter",
  add.params = list(alpha = 0.3),
  ...
)

show_sig_bootstrap_error(
  bt_result,
  sample = NULL,
  methods = "LS",
  palette = "aaas",
  title = NULL,
  xlab = FALSE,
  ylab = "Decomposition error",
  width = 0.3,
  dodge_width = 0.8,
  outlier.shape = NA,
  add = "jitter",
  add.params = list(alpha = 0.3),
  legend = "none",
  ...
)

show_sig_bootstrap_stability(
  bt_result,
  signatures = NULL,
  measure = c("MRSE", "MAE", "AbsDiff"),
  methods = "LS",
  palette = "aaas",
  title = NULL,
  xlab = FALSE,
  ylab = "Signature instability",
  width = 0.3,
  outlier.shape = NA,
  add = "jitter",
  add.params = list(alpha = 0.3),
  ...
)
}
\arguments{
\item{bt_result}{result object from \link{sig_fit_bootstrap_batch}.}

\item{sample}{a sample id.}

\item{signatures}{signatures to show.}

\item{methods}{a subset of \code{c("LS", "QP", "SA")}.}

\item{palette}{the color palette to be used for coloring or filling by groups.
Allowed values include "grey" for grey color palettes; brewer palettes e.g.
"RdBu", "Blues", ...; or custom color palette e.g. c("blue", "red"); and
scientific journal palettes from ggsci R package, e.g.: "npg", "aaas",
"lancet", "jco", "ucscgb", "uchicago", "simpsons" and "rickandmorty".}

\item{title}{plot main title.}

\item{xlab}{character vector specifying x axis labels. Use xlab = FALSE to
hide xlab.}

\item{ylab}{character vector specifying y axis labels. Use ylab = FALSE to
hide ylab.}

\item{width}{numeric value between 0 and 1 specifying box width.}

\item{dodge_width}{dodge width.}

\item{outlier.shape}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{add}{character vector for adding another plot element (e.g.: dot plot or
error bars). Allowed values are one or the combination of: "none",
"dotplot", "jitter", "boxplot", "point", "mean", "mean_se", "mean_sd",
"mean_ci", "mean_range", "median", "median_iqr", "median_mad",
"median_range"; see ?desc_statby for more details.}

\item{add.params}{parameters (color, shape, size, fill, linetype) for the
argument 'add'; e.g.: add.params = list(color = "red").}

\item{...}{other parameters passing to \link[ggpubr:ggboxplot]{ggpubr::ggboxplot}.}

\item{legend}{character specifying legend position. Allowed values are one of
c("top", "bottom", "left", "right", "none"). To remove the legend use
legend = "none". Legend position can be also specified using a numeric
vector c(x, y); see details section.}

\item{measure}{measure to estimate the exposure instability, can be one of 'MRSE', 'MAE' and 'AbsDiff'.}
}
\value{
a \code{ggplot} object
}
\description{
See details for description.
}
\details{
Functions:
\itemize{
\item \link{show_sig_bootstrap_exposure} - this function plots exposures from bootstrap samples with both dotted boxplot.
The optimal exposure (the exposure from original input) is shown as triangle point. \strong{Only one sample can be plotted}.
\item \link{show_sig_bootstrap_error} - this function plots decomposition errors from bootstrap samples with both dotted boxplot.
The error from optimal solution (the decomposition error from original input) is shown as triangle point. \strong{Only one sample can be plotted}.
\item \link{show_sig_bootstrap_stability} - this function plots the signature exposure instability for specified signatures. Currently,
the instability measure supports 3 types:
\itemize{
\item 'MRSE' for Mean Root Squared Error (default) of bootstrap exposures and original exposures for each sample.
\item 'MAE' for Mean Absolute Error of bootstrap exposures and original exposures for each sample.
\item 'AbsDiff' for Absolute Difference between mean bootstram exposure and original exposure.
}
}
}
\examples{
\donttest{
if (require("BSgenome.Hsapiens.UCSC.hg19")) {
  laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
  laml <- read_maf(maf = laml.maf)
  mt_tally <- sig_tally(
    laml,
    ref_genome = "BSgenome.Hsapiens.UCSC.hg19",
    use_syn = TRUE
  )

  library(NMF)
  mt_sig <- sig_extract(mt_tally$nmf_matrix,
    n_sig = 3,
    nrun = 2,
    cores = 1,
    pConstant = 1e-13
  )

  mat <- t(mt_tally$nmf_matrix)
  mat <- mat[, colSums(mat) > 0]
  bt_result <- sig_fit_bootstrap_batch(mat, sig = mt_sig, n = 10)
  ## Parallel computation
  ## bt_result = sig_fit_bootstrap_batch(mat, sig = mt_sig, n = 10, use_parallel = TRUE)

  ## Show bootstrap exposure (optimal exposure is shown as triangle)
  p1 <- show_sig_bootstrap_exposure(bt_result, methods = c("LS", "QP"))
  p1
  p2 <- show_sig_bootstrap_exposure(bt_result, methods = c("LS", "QP"),
                                               sample = "TCGA-AB-3012",
                                               signatures = c("Sig1", "Sig2"))
  p2

  ## Show bootstrap error
  p3 <- show_sig_bootstrap_error(bt_result, methods = c("LS", "QP"))
  p3

  ## Show exposure (in)stability
  p4 <- show_sig_bootstrap_stability(bt_result, methods = c("LS", "QP"))
  p4
  p5 <- show_sig_bootstrap_stability(bt_result, methods = c("LS", "QP"), measure = "MAE")
  p5
  p6 <- show_sig_bootstrap_stability(bt_result, methods = c("LS", "QP"), measure = "AbsDiff")
  p6

} else {
  message("Please install package 'BSgenome.Hsapiens.UCSC.hg19' firstly!")
}
}
}
\references{
Huang X, Wojtowicz D, Przytycka TM. Detecting presence of mutational signatures in cancer with confidence. Bioinformatics. 2018;34(2):330–337. doi:10.1093/bioinformatics/btx604
}
\seealso{
\link{sig_fit_bootstrap_batch}, \link{sig_fit}, \link{sig_fit_bootstrap}
}
