% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature_series.R
\name{sig_extract}
\alias{sig_extract}
\title{Extract variation signatures}
\usage{
sig_extract(nmf_matrix, n_sig, mode = c("copynumber", "mutation"),
  nrun = 10, cores = 1, method = "brunet", pConstant = NULL,
  seed = 123456)
}
\arguments{
\item{nmf_matrix}{a \code{matrix} used for NMF decomposition (with rownames and colnames),
generate from \link{sig_prepare} function.}

\item{n_sig}{number of signature. Please run \link{sig_prepare} to select a suitable value.}

\item{mode}{variation type to decompose, currently support "copynumber" or "mutation".}

\item{nrun}{a \code{numeric} giving the number of run to perform for each value in \code{range}, \code{nrun} set to 30~50 is enough to achieve robust result.}

\item{cores}{number of cpu cores to run NMF.}

\item{method}{specification of the NMF algorithm. Use 'brunet' as default.
Available methods for nmf decompositions are 'brunet', 'lee', 'ls-nmf', 'nsNMF', 'offset'.}

\item{pConstant}{A small positive value to add to the matrix. Use it ONLY if the functions throws an \code{non-conformable arrays} error.}

\item{seed}{specification of the starting point or seeding method, which will compute a starting point, usually using data from the target matrix in order to provide a good guess.}
}
\value{
a \code{list} contains NMF object, signature matrix and activity matrix.
}
\description{
Do NMF de-composition and then extract signatures.
}
\examples{
\donttest{
# Load copy number prepare object
load(system.file("extdata", "toy_copynumber_prepare.RData",
  package = "sigminer", mustWork = TRUE
))
# Extract copy number signatures
res <- sig_extract(cn_prepare$nmf_matrix, 2, mode = "copynumber", nrun = 1)
}
}
\references{
Gaujoux, Renaud, and Cathal Seoighe. "A flexible R package for nonnegative matrix factorization." BMC bioinformatics 11.1 (2010): 367.

Mayakonda, Anand, et al. "Maftools: efficient and comprehensive analysis of somatic variants in cancer." Genome research 28.11 (2018): 1747-1756.
}
\seealso{
Other signature analysis series function: \code{\link{sig_assign_samples}},
  \code{\link{sig_estimate}},
  \code{\link{sig_get_activity}},
  \code{\link{sig_get_correlation}},
  \code{\link{sig_get_similarity}},
  \code{\link{sig_prepare}},
  \code{\link{sig_summarize_subtypes}}
}
\author{
Shixiang Wang
}
\concept{signature analysis series function}
