% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.summary.sievePH.R
\name{plot.summary.sievePH}
\alias{plot.summary.sievePH}
\title{Plotting Mark-Specific Proportional Hazards Model Fits}
\usage{
\method{plot}{summary.sievePH}(x, mark = NULL, tx = NULL,
  xlim = NULL, ylim = NULL, zlim = NULL, xtickAt = NULL,
  xtickLab = NULL, ytickAt = NULL, ytickLab = NULL, xlab = NULL,
  ylab = NULL, zlab = NULL, txLab = c("Placebo", "Treatment"),
  title = NULL, ...)
}
\arguments{
\item{x}{an object returned by \code{\link{summary.sievePH}}}

\item{mark}{either a numeric vector specifying a univariate continuous mark or a data frame specifying a multivariate continuous mark.
For subjects with a right-censored time-to-event, the value(s) in \code{mark} should be set to \code{NA}.}

\item{tx}{a numeric vector indicating the treatment group (1 if treatment, 0 if placebo)}

\item{xlim}{a numeric vector of length 2 specifying the x-axis range (\code{NULL} by default)}

\item{ylim}{a numeric vector of length 2 specifying the y-axis range (\code{NULL} by default)}

\item{zlim}{a numeric vector of length 2 specifying the z-axis range in a 3-dimensional plot (\code{NULL} by default)}

\item{xtickAt}{a numeric vector specifing the position of x-axis tickmarks (\code{NULL} by default)}

\item{xtickLab}{a numeric vector specifying labels for tickmarks listed in \code{xtickAt}. If \code{NULL} (default), the labels are determined by \code{xtickAt}.}

\item{ytickAt}{a numeric vector specifing the position of y-axis tickmarks (\code{NULL} by default)}

\item{ytickLab}{a numeric vector specifying labels for tickmarks listed in \code{ytickAt}. If \code{NULL} (default), the labels are determined by \code{ytickAt}.}

\item{xlab}{a character string specifying the x-axis label (\code{NULL} by default)}

\item{ylab}{a character string specifying the y-axis label (\code{NULL} by default)}

\item{zlab}{a character string specifying the z-axis label in a 3-dimensional plot (\code{NULL} by default)}

\item{txLab}{a character vector of length 2 specifying the placebo and treatment labels (in this order). The default labels are \code{placebo} and \code{treatment}.}

\item{title}{a character string specifying the plot title (\code{NULL} by default)}

\item{...}{other arguments to be passed to plotting functions}
}
\value{
None. The function is called solely for plot generation.
}
\description{
\code{plot} method for class \code{summary.sievePH}. For univariate marks, it plots point and interval estimates of the mark-specific treatment effect parameter specified by \code{contrast} in \code{\link{summary.sievePH}}, and,
optionally, scatter/box plots of the observed mark values by treatment. For bivariate marks, plotting is restricted to the point estimate, which is displayed as a surface. No plotting is provided for marks of higher dimensions.
}
\details{
For bivariate marks, \code{markGrid} in \code{\link{summary.sievePH}} must have equally spaced values for each component.
}
\examples{
n <- 500
tx <- rep(0:1, each=n/2)
tm <- c(rexp(n/2, 0.2), rexp(n/2, 0.2 * exp(-0.4)))
cens <- runif(n, 0, 15)
eventTime <- pmin(tm, cens, 3)
eventInd <- as.numeric(tm <= pmin(cens, 3))
mark <- ifelse(eventInd==1, c(rbeta(n/2, 2, 5), rbeta(n/2, 2, 2)), NA)
markRng <- range(mark, na.rm=TRUE)

# fit a model with a univariate mark
fit <- sievePH(eventTime, eventInd, mark, tx)
sfit <- summary(fit, markGrid=seq(markRng[1], markRng[2], length.out=10))
plot(sfit, mark, tx)

}
\seealso{
\code{\link{sievePH}}, \code{\link{sievePHipw}}, \code{\link{sievePHaipw}} and \code{\link{summary.sievePH}}
}
