nt.gap.comb <-
function(DISTnuc=NA,DISTgap=NA,alpha=seq(0,1,0.1),method="Corrected",saveFile=TRUE)
{
require(ape)

CORnuc<-DISTnuc/(max(DISTnuc))
CORgap<-DISTgap/(max(DISTgap))

if(length(alpha)==1)
{#as a matrix if only one alpha value is defined

if(method=="Uncorrected")
{
	alfa<-alpha
	DIST<-(1-alfa)*DISTnuc+alfa*DISTgap
	if(saveFile==TRUE)
	write.table(DIST,file=paste	("DistanceMatrixUncorrectedAlpha",alfa,sep="_"))
	OUTuncor<-DIST
}

if(method=="Corrected")
{
	alfa<-alpha
	COR<-(1-alfa)*CORnuc+alfa*CORgap
	if(saveFile==TRUE)
	write.table(COR,file=paste("DistanceMatrixCorrectedAlpha",alfa,sep="_"))
	OUTcor<-COR
}
}#as a matrix if only one alpha value is defined



if(length(alpha)>1)
{						#as a list if a alpha is defined
OUTuncor<-list(c())
OUTcor<-list(c())


if(method=="Uncorrected")
{
	for(ite1 in 1:length(alpha))
	{
	alfa<-alpha[ite1]
	DIST<-(1-alfa)*DISTnuc+alfa*DISTgap
	if(saveFile==TRUE)
	write.table(DIST,file=paste	("DistanceMatrixUncorrectedAlpha",alfa,sep="_"))
	OUTuncor[[ite1]]<-DIST
	}
}

if(method=="Corrected")
{
	for(ite1 in 1:length(alpha))
	{
	alfa<-alpha[ite1]
	COR<-(1-alfa)*CORnuc+alfa*CORgap
	if(saveFile==TRUE)
	write.table(COR,file=paste("DistanceMatrixCorrectedAlpha",alfa,sep="_"))
	OUTcor[[ite1]]<-COR
	}
}
}#as a list if a alpha is defined

if(method=="Uncorrected")
OUT<-OUTuncor

if(method=="Corrected")
OUT<-OUTcor

print(OUT)
}

