% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_funs.R
\name{LPDS}
\alias{LPDS}
\title{Calculate the Log Predictive Density Score for a fitted TVP model}
\usage{
LPDS(mod, data_test)
}
\arguments{
\item{mod}{an object of class \code{shrinkTVP}, containing the fitted model for which the LPDS should be calculated.}

\item{data_test}{a data frame with one row, containing the one step ahead covariates and response. The names of the covariates
and the response have to match the names used during model estimation in the call to \code{shrinkTVP}.}
}
\value{
A real number equaling the calculated LPDS.
}
\description{
\code{LPDS} calculates the one step ahead Log Predictive Density Score (LPDS) of a fitted TVP model resulting from a call to
shrinkTVP. For details on the approximation of the one-step ahead predictive density used, see the vignette.
}
\examples{
\donttest{
# Simulate data
set.seed(123)
sim <- simTVP(theta = c(0.2, 0, 0), beta_mean = c(1.5, -0.3, 0))
data <- sim$data

# Estimate model
res <- shrinkTVP(y ~ x1 + x2, data = data[1:199, ])

# Calculate LPDS
LPDS(res, data[200,])
}

}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
