% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_using_split_times.R
\name{mixed_model_using_split_times}
\alias{mixed_model_using_split_times}
\title{Mixed Model Using Split Times}
\usage{
mixed_model_using_split_times(data, distance, time, athlete, na.rm = FALSE)
}
\arguments{
\item{data}{Data frame}

\item{distance}{Character string. Name of the column in \code{data}}

\item{time}{Character string. Name of the column in \code{data}}

\item{athlete}{Character string. Name of the column in \code{data}. Used as levels in the \code{\link[nlme]{nlme}}}

\item{na.rm}{Logical. Default is FALSE}
}
\value{
List object with the following elements:
    \describe{
        \item{parameters}{List with two data frames: \code{fixed} and \code{random} containing the following
            estimated parameters: \code{MSS}, \code{TAU}, \code{MAC}, and \code{PMAX}}
        \item{model_fit}{List with the following components:
            \code{RSE}, \code{R_squared}, \code{minErr}, \code{maxErr},
            \code{maxAbsErr}, and \code{RMSE}}
        \item{model}{Model returned by the \code{\link[nlme]{nlme}} function}
        \item{data}{Data frame used to estimate the sprint parameters, consisting of \code{athlete}, \code{distance},
            \code{time}, and  \code{pred_time} columns}
        }
}
\description{
This function models the sprint split times using mono-exponential equation and non-linear
    mixed model using \code{\link[nlme]{nlme}} to estimate fixed and random maximum sprinting speed (\code{MSS})
    and relative acceleration (\code{TAU}) parameters. In mixed model, fixed and random effects are estimated for
    \code{MSS} and \code{TAU} parameters using \code{athlete} as levels. \code{time} is used as target or outcome
    variable, and \code{distance} as predictor.
}
\examples{
data("split_times")

mixed_model <- mixed_model_using_split_times(split_times, "distance", "time", "athlete")
mixed_model$parameters
}
