% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{MRPWorkflow-method-estimate_plot}
\alias{MRPWorkflow-method-estimate_plot}
\alias{estimate_plot}
\title{Visualize estimates for demographic groups}
\usage{
estimate_plot(
  model,
  group = NULL,
  interval = 0.95,
  show_caption = TRUE,
  file = NULL,
  ...
)
}
\arguments{
\item{model}{Fitted MRPModel object}

\item{group}{Character string specifying the demographic group.
If left as \code{NULL}, overall estimates are plotted.}

\item{interval}{Confidence interval (a numeric value between 0 and 1) or
standard deviation (\code{"1sd"} or \code{"2sd"}) for the estimates (default is 0.95).}

\item{show_caption}{Logical indicating whether to show the caption in the plot (default is TRUE).}

\item{file}{Optional file path to save the plot.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:ggsave]{ggsave}}, such as \code{width} and \code{height}.}
}
\value{
A ggplot object showing MRP estimates.
}
\description{
The \verb{$estimate_plot()} method creates plots showing overall MRP estimates or
estimates for different demographic groups. Check out the
\href{https://mrp-interface.github.io/shinymrp/articles/example#estimate_plot}{More examples of R6 classes}
vignette for usage examples.
}
