% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fullscreen_those.R
\name{fullscreen_those}
\alias{fullscreen_those}
\title{Enable fullscreen for a list of items}
\usage{
fullscreen_those(items = list(), bg_color = "#fff")
}
\arguments{
\item{items}{A list containing the ids of the items for which fullscreen is enabled.}

\item{bg_color}{Background color when item is displayed full screen. Default is white.}
}
\value{
Enables the selected elements to be displayed in fullscreen mode.
}
\description{
Enable fullscreen for a list of items
}
\details{
This function has to be placed AFTER the call of inputs. See Examples.
}
\examples{
if (interactive()) {
### Only works in browser

library(shiny)
library(shinyfullscreen)

ui <- fluidPage(
  plotOutput("plot"),
  plotOutput("plot2"),

  # Has to be placed after plot and plot2
  fullscreen_those(items = list("plot", "plot2"))
)

server <- function(input, output, session) {

  output$plot <- renderPlot(plot(mtcars))
  output$plot2 <- renderPlot(plot(AirPassengers))

}

shinyApp(ui, server, options = list(launch.browser = TRUE))
}
}
