% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{config_report}
\alias{config_report}
\title{Configure options for \code{\link[=report]{report()}} and others}
\usage{
config_report(
  svgColor = NULL,
  titleColor = NULL,
  messageColor = NULL,
  buttonBackground = NULL,
  buttonColor = NULL,
  backOverlayColor = NULL,
  className = NULL,
  width = NULL,
  backgroundColor = NULL,
  borderRadius = NULL,
  rtl = NULL,
  zindex = NULL,
  backOverlay = NULL,
  fontFamily = NULL,
  svgSize = NULL,
  plainText = NULL,
  titleFontSize = NULL,
  titleMaxLength = NULL,
  messageFontSize = NULL,
  messageMaxLength = NULL,
  buttonFontSize = NULL,
  buttonMaxLength = NULL,
  cssAnimation = NULL,
  cssAnimationDuration = NULL,
  cssAnimationStyle = NULL,
  ...
)
}
\arguments{
\item{svgColor}{Changes the built-in SVG icon color.}

\item{titleColor}{Changes the title text color.}

\item{messageColor}{Changes the message text color.}

\item{buttonBackground}{Changes the button background color.}

\item{buttonColor}{Changes the button text color.}

\item{backOverlayColor}{Changes the color of the background overlay.}

\item{className}{Changes the class name (attribute).}

\item{width}{Changes the width.}

\item{backgroundColor}{Changes the background color.}

\item{borderRadius}{Changes the radius of the corners.}

\item{rtl}{Specifies the text direction to "right-to-left".}

\item{zindex}{Changes the z-index.}

\item{backOverlay}{Adds a background overlay.}

\item{fontFamily}{Changes the font-family.}

\item{svgSize}{Changes the built-in SVG icons width and height. (Notiflix uses square scaled icons.)}

\item{plainText}{Strips all HTML tags.}

\item{titleFontSize}{Changes the font-size of the title text.}

\item{titleMaxLength}{The maximum length of the title text.}

\item{messageFontSize}{Changes the font-size of the message text.}

\item{messageMaxLength}{The maximum length of the message text.}

\item{buttonFontSize}{Changes the font-size of the button text.}

\item{buttonMaxLength}{The maximum length of the button text.}

\item{cssAnimation}{Enables/disables CSS animations to show/hide.}

\item{cssAnimationDuration}{Changes the CSS animations duration as milliseconds.}

\item{cssAnimationStyle}{2 types of styles can be used: fade zoom.}

\item{...}{Other potential arguments.}
}
\value{
A config \code{list} that can be used in \code{\link[=report]{report()}} and other \verb{report_*} functions.
}
\description{
Options for \code{\link[=report]{report()}} functions, see
\href{https://notiflix.github.io/documentation}{online documentation}
for default values and examples.
}
\examples{
library(shiny)
library(shinybusy)

ui <- fluidPage(
  tags$h2("Config for report() examples"),
  actionButton("success", "Success"),
  actionButton("failure", "Failure"),
  actionButton("info", "Info")
)

server <- function(input, output, session) {

  observeEvent(input$success, {
    report_success(
      "Well done!",
      "All in order",
      config_report(
        svgColor = "#0431B4",
        titleColor = "#0431B4"
      )
    )
  })

  observeEvent(input$failure, {
    report_failure(
      "Oups...",
      "Something went wrong",
      config_report(
        svgColor = "#DF01D7",
        titleColor = "#DF01D7"
      )
    )
  })

  observeEvent(input$info, {
    report_info(
      "For your information",
      tags$p(
        style = "font-style: italic;",
        "Lorem ipsum dolor sit amet"
      ),
      config_report(width = "560px", borderRadius = "5px")
    )
  })

}

if (interactive())
  shinyApp(ui, server)
}
