% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-autonumeric.R
\name{currencyInput}
\alias{currencyInput}
\alias{formatNumericInput}
\title{Format Numeric Inputs}
\usage{
currencyInput(
  inputId,
  label,
  value,
  format = "euro",
  width = NULL,
  align = "center"
)

formatNumericInput(
  inputId,
  label,
  value,
  format = "commaDecimalCharDotSeparator",
  width = NULL,
  align = "center"
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or NULL for no label.}

\item{value}{Initial value (unformatted).}

\item{format}{A character string specifying the currency format of the
input.  See "Details" for possible values.}

\item{width}{The width of the input box, eg. \code{"200px"} or
\code{"100\%"}.}

\item{align}{The alignment of the text inside the input box, one of
"center", "left", "right". Defaults to "center".}
}
\value{
a currency input widget that can be added to the UI of a shiny app.
}
\description{
Shiny widgets for as-you-type formatting of currency and numeric values. For
a more modifiable version see \code{\link[=autonumericInput]{autonumericInput()}}. These two
functions do the exact same thing but are named differently for more
intuitive use (currency for money, formatNumeric for percentage or other).
}
\details{
In regards to \code{format}, there are currently 41 sets of predefined
options that can be used, most of which are variations of one another.
The most common are:
\itemize{
\item "French"
\item "Spanish"
\item "NorthAmerican"
\item "British"
\item "Swiss"
\item "Japanese"
\item "Chinese"
\item "Brazilian"
\item "Turkish"
\item "euro" (same as "French")
\item "dollar" (same as "NorthAmerican")
\item "percentageEU2dec"
\item "percentageUS2dec"
\item "dotDecimalCharCommaSeparator"
\item "commaDecimalCharDotSeparator"
}

To see the full list please visit
\href{https://github.com/autoNumeric/autoNumeric/#predefined-common-options}{this section}
of the AutoNumeric Github Page.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(
    tags$h2("Currency Input"),

    currencyInput("id1", "Euro:", value = 1234, format = "euro", width = 200, align = "right"),
    verbatimTextOutput("res1"),

    currencyInput("id2", "Dollar:", value = 1234, format = "dollar", width = 200, align = "right"),
    verbatimTextOutput("res2"),

    currencyInput("id3", "Yen:", value = 1234, format = "Japanese", width = 200, align = "right"),
    verbatimTextOutput("res3"),

    br(),
    tags$h2("Formatted Numeric Input"),

    formatNumericInput("id4", "Numeric:", value = 1234, width = 200),
    verbatimTextOutput("res4"),

    formatNumericInput("id5", "Percent:", value = 1234, width = 200, format = "percentageEU2dec"),
    verbatimTextOutput("res5")
  )

  server <- function(input, output, session) {
    output$res1 <- renderPrint(input$id1)
    output$res2 <- renderPrint(input$id2)
    output$res3 <- renderPrint(input$id3)
    output$res4 <- renderPrint(input$id4)
    output$res5 <- renderPrint(input$id5)
  }

  shinyApp(ui, server)
}
}
\references{
Bonneau, Alexandre. 2018. "AutoNumeric.js javascript Package". http://autonumeric.org
}
\seealso{
Other autonumeric: 
\code{\link{autonumericInput}()},
\code{\link{updateAutonumericInput}()},
\code{\link{updateCurrencyInput}()}
}
\concept{autonumeric}
