% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-awesomecheckbox.R
\name{updateAwesomeCheckbox}
\alias{updateAwesomeCheckbox}
\title{Change the value of an awesome checkbox input on the client}
\usage{
updateAwesomeCheckbox(session, inputId, label = NULL, value = NULL)
}
\arguments{
\item{session}{standard \code{shiny} session}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}
}
\description{
Change the value of an awesome checkbox input on the client
}
\examples{
if (interactive()) {

library("shiny")
library("shinyWidgets")


ui <- fluidPage(
  awesomeCheckbox(
    inputId = "somevalue",
    label = "My label",
    value = FALSE
  ),

  verbatimTextOutput(outputId = "res"),

  actionButton(inputId = "updatevalue", label = "Toggle value"),
  textInput(inputId = "updatelabel", label = "Update label")
)

server <- function(input, output, session) {

  output$res <- renderPrint({
    input$somevalue
  })

  observeEvent(input$updatevalue, {
    updateAwesomeCheckbox(
      session = session, inputId = "somevalue",
      value = as.logical(input$updatevalue \%\%2)
    )
  })

  observeEvent(input$updatelabel, {
    updateAwesomeCheckbox(
      session = session, inputId = "somevalue",
      label = input$updatelabel
    )
  }, ignoreInit = TRUE)

}

shinyApp(ui = ui, server = server)

}
}
\seealso{
\code{\link{awesomeCheckbox}}
}
