% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsampler.R
\docType{class}
\name{downsampler}
\alias{downsampler}
\title{R6 class for down-sampling data}
\format{
An \code{R6::R6Class} object
}
\description{
A class for down-sampling data with a large number of samples.
An instance contains (the reference of) original data, layout of the figure,
and options for aggregating the original data.
An interactive plot for displaying large-sized data can be obtained using
the figure, down-sampler and its options included in the instance,
while making the plot using \code{shiny_hugeplot} function is easier (see examples).
See the super class (\code{plotly_datahandler}) to find more members
to handle the data in \code{plotly}.
}
\examples{
\donttest{
data(noise_fluct)

# example 1 : Easy method using shiny_hugeplot
shiny_hugeplot(noise_fluct$time, noise_fluct$f500)

# example 2 : Manual method using a downsampler object
fig <- plot_ly(
  x = noise_fluct$time,
  y = noise_fluct$f500,
  type = "scatter",
  mode = "lines"
  ) \%>\%
  layout(xaxis = list(type = "date")) \%>\%
  shinyHugePlot::plotly_build_light()

ds <- downsampler$new(
  figure = fig,
  aggregator = min_max_aggregator$new(interleave_gaps = TRUE)
)

ui <- fluidPage(
  plotlyOutput(outputId = "hp", width = "800px", height = "600px")
)

server <- function(input, output, session) {

  output$hp <- renderPlotly(ds$figure)

  observeEvent(plotly::event_data("plotly_relayout"),{
    updatePlotlyH(session, "hp", plotly::event_data("plotly_relayout"), ds)
  })

}

shinyApp(ui = ui, server = server)

}
}
\section{Super class}{
\code{shinyHugePlot::plotly_datahandler} -> \code{downsampler}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{downsample_options}}{Options for aggregating (down-sampling) data
registered in this instance.}

\item{\code{n_out_default}}{Default sample size.}

\item{\code{aggregator_default}}{Default aggregator instance.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-downsampler-new}{\code{downsampler$new()}}
\item \href{#method-downsampler-add_trace}{\code{downsampler$add_trace()}}
\item \href{#method-downsampler-update_trace}{\code{downsampler$update_trace()}}
\item \href{#method-downsampler-set_downsample_options}{\code{downsampler$set_downsample_options()}}
\item \href{#method-downsampler-clone}{\code{downsampler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="plotly_datahandler" data-id="plotly_data_to_df"><a href='../../shinyHugePlot/html/plotly_datahandler.html#method-plotly_datahandler-plotly_data_to_df'><code>shinyHugePlot::plotly_datahandler$plotly_data_to_df()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="plotly_datahandler" data-id="set_trace_data"><a href='../../shinyHugePlot/html/plotly_datahandler.html#method-plotly_datahandler-set_trace_data'><code>shinyHugePlot::plotly_datahandler$set_trace_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-downsampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-downsampler-new}{}}}
\subsection{Method \code{new()}}{
To construct an instance, original data, layout of the figure, and options
for aggregating the original data are necessary.
The original data and the layout of the figure can be given by providing
a \code{plotly} object (\code{figure} argument).
The options for aggregating the original data can be given by providing
an aggregator (\code{aggregator} argument) and the number of samples
(\code{n_out} argument).
See the constructor of the \code{plotly_datahandler} class for more
information on other arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{downsampler$new(
  figure = NULL,
  n_out = 1000L,
  aggregator = min_max_aggregator$new(),
  tz = Sys.timezone(),
  use_light_build = TRUE,
  legend_options = list(name_prefix = "<b style=\\"color:sandybrown\\">[S]</b> ",
    name_suffix = "", xdiff_prefix = "<i style=\\"color:#fc9944\\"> ~", xdiff_suffix =
    "</i>")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{figure, legend_options, tz, use_light_build}}{Arguments passed to \code{plotly_datahandler$new}.}

\item{\code{n_out}}{Integer or numeric.
The number of samples shown after down-sampling. By default 1000.}

\item{\code{aggregator}}{An instance of an R6 class for aggregation.
Select an aggregation function. The list of the functions are obtained
using \code{list_aggregators}.
By default, \code{min_max_aggregator$new()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-downsampler-add_trace"></a>}}
\if{latex}{\out{\hypertarget{method-downsampler-add_trace}{}}}
\subsection{Method \code{add_trace()}}{
Add a new series to the data registered in the instance.
If a data frame (\code{traces_df} argument) compliant with
\code{self$orig_data} is given, it will be added to \code{self$orig_data}.
If attributes to construct a \code{plotly} object (\code{...} argument)
are given, a data frame is constructed and added.
Options for aggregating data can be set using
\code{aggregator} and \code{n_out} arguments.
It is a wrapper of \code{self$set_trace_data} and
\code{self$set_downsample_options}. See these methods for more information.
Note that the traces of the figure are not updated with this method and
\code{self$update_trace} is necessary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{downsampler$add_trace(..., traces_df = NULL, n_out = NULL, aggregator = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{..., traces_df}}{Arguments passed to \code{self$set_trace_data}}

\item{\code{n_out, aggregator}}{Arguments passed to \code{self$set_downsample_options}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-downsampler-update_trace"></a>}}
\if{latex}{\out{\hypertarget{method-downsampler-update_trace}{}}}
\subsection{Method \code{update_trace()}}{
Update traces of the figure registered in the instance
(\code{self$figure$x$data}) according to
re-layout order (\code{relayout_order} argument).
Using \code{reset} and \code{reload} arguments, traces are updated
without re-layout orders.
It just registers the new traces and returns nothing by default.
It returns the new traces if \code{send_trace} is \code{TRUE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{downsampler$update_trace(
  relayout_order = list(NULL),
  reset = FALSE,
  reload = FALSE,
  send_trace = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{relayout_order}}{Named list.
A list generated by \code{plotlyjs_relayout},
which is obtained using \code{plotly::event_data}.
e.g.,
If you would like set the range of the 2nd x axis to [10.0, 21.5],
\code{list(`xaxis2.range[0]` = 10.0, `xaxis2.range[1]` = 21.5)}.
If you would like reset the range of the 1st x axis,
\code{list(xaxis.autorange = TRUE, xaxis.showspike = TRUE)}.}

\item{\code{reset}}{Boolean.
If it is \code{TRUE}, all other arguments are neglected and
the figure will be reset (all the ranges of x axes are initialized).
By default, \code{FALSE}.}

\item{\code{reload}}{Boolean.
If it is \code{TRUE}, the ranges of the figure are preserved but
the aggregation will be conducted with the current settings.
By default, \code{FALSE}.}

\item{\code{send_trace}}{Boolean.
If it is \code{TRUE}, a named list will be returned,
which contains the indexes of the traces that will be updated
(\code{trace_idx_update}) and the updated traces (\code{new_trace}).
By default, \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-downsampler-set_downsample_options"></a>}}
\if{latex}{\out{\hypertarget{method-downsampler-set_downsample_options}{}}}
\subsection{Method \code{set_downsample_options()}}{
In the instance, options for aggregating data are registered as data frame.
(see \code{self$downsample_options}.)
Using this method, the options can be set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{downsampler$set_downsample_options(uid = NULL, n_out = NULL, aggregator = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uid}}{Character, optional.
The unique id of the trace.
If \code{NULL}, all the options registered in this instance are updated.
By default, \code{NULL}.}

\item{\code{n_out}}{Numeric or integer, optional.
The number of samples output by the aggregator.
If \code{NULL}, the default value registered in this instance is used.
By default, \code{NULL}.}

\item{\code{aggregator}}{\code{aggregator} object, optional.
An instance that aggregate the data.
If \code{NULL}, the default value registered in this instance is used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-downsampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-downsampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{downsampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
