% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_input.R
\name{text_Input}
\alias{text_Input}
\title{Text Input Function}
\usage{
text_Input(
  inputId,
  label,
  hint_label = NULL,
  type = "text",
  width = NULL,
  error = FALSE,
  error_message = NULL,
  prefix = NULL,
  suffix = NULL
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{hint_label}{Display hint label for the control, or \code{NULL} for
no hint label.}

\item{type}{Type of text input to accept.  Defaults to text.}

\item{width}{control the size of the box based on number of characters
required.  Options are 30, 20, 10, 5, 4, 3, 2.  NULL will not limit the size}

\item{error}{Whenever to include error handling  Defaults to FALSE.}

\item{error_message}{Message to display on error.  Defaults to NULL}

\item{prefix}{Add a prefix to the box.  Defaults to NULL}

\item{suffix}{Add a suffix to the box.  Defaults to NULL}
}
\value{
a text input html shiny object
}
\description{
This function create a text area input
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

  ui <- fluidPage(
    # Required for error handling function
    shinyjs::useShinyjs(),
    shinyGovstyle::header(
      main_text = "Example",
      secondary_text = "User Examples",
      logo="shinyGovstyle/images/moj_logo.png"),
    shinyGovstyle::banner(
      inputId = "banner", type = "beta", 'This is a new service'),
    shinyGovstyle::gov_layout(size = "two-thirds",
      # Simple text box
      shinyGovstyle::text_Input(inputId = "eventId", label = "Event Name"),
      # Error text box
      shinyGovstyle::text_Input(
        inputId = "eventId2",
        label = "Event Name",
        hint_label = "This can be found on the letter",
        error = TRUE),
      # Button to trigger error
      shinyGovstyle::button_Input(inputId = "submit", label = "Submit")
    ),
    shinyGovstyle::footer(full = TRUE)
  )


  server <- function(input, output, session) {
    #Trigger error on blank submit of eventId2
    observeEvent(input$submit, {
      if (input$eventId2 != ""){
        shinyGovstyle::error_off(inputId = "eventId2")
      } else {
        shinyGovstyle::error_on(
          inputId = "eventId2",
          error_message = "Please complete")
      }
    })
  }

  # Run the application
  shinyApp(ui = ui, server = server)
}
}
\keyword{input}
\keyword{text}
