% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert-tab.R
\name{showTab}
\alias{showTab}
\alias{hideTab}
\title{Dynamically hide/show a tabPanel}
\usage{
showTab(inputId, target, select = FALSE,
  session = getDefaultReactiveDomain())

hideTab(inputId, target, session = getDefaultReactiveDomain())
}
\arguments{
\item{inputId}{The \code{id} of the \code{tabsetPanel} (or
\code{navlistPanel} or \code{navbarPage}) in which to find
\code{target}.}

\item{target}{The \code{value} of the \code{tabPanel} to be
hidden/shown. See Details if you want to hide/show an entire
\code{navbarMenu} instead.}

\item{select}{Should \code{target} be selected upon being shown?}

\item{session}{The shiny session within which to call this function.}
}
\description{
Dynamically hide or show a \code{\link{tabPanel}} (or a
\code{\link{navbarMenu}})from an existing \code{\link{tabsetPanel}},
\code{\link{navlistPanel}} or \code{\link{navbarPage}}.
}
\details{
For \code{navbarPage}, you can hide/show conventional
\code{tabPanel}s (whether at the top level or nested inside a
\code{navbarMenu}), as well as an entire \code{\link{navbarMenu}}.
For the latter case, \code{target} should be the \code{menuName} that
you gave your \code{navbarMenu} when you first created it (by default,
this is equal to the value of the \code{title} argument).
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {

ui <- navbarPage("Navbar page", id = "tabs",
  tabPanel("Home",
    actionButton("hideTab", "Hide 'Foo' tab"),
    actionButton("showTab", "Show 'Foo' tab"),
    actionButton("hideMenu", "Hide 'More' navbarMenu"),
    actionButton("showMenu", "Show 'More' navbarMenu")
  ),
  tabPanel("Foo", "This is the foo tab"),
  tabPanel("Bar", "This is the bar tab"),
  navbarMenu("More",
    tabPanel("Table", "Table page"),
    tabPanel("About", "About page"),
    "------",
    "Even more!",
    tabPanel("Email", "Email page")
  )
)

server <- function(input, output, session) {
  observeEvent(input$hideTab, {
    hideTab(inputId = "tabs", target = "Foo")
  })

  observeEvent(input$showTab, {
    showTab(inputId = "tabs", target = "Foo")
  })

  observeEvent(input$hideMenu, {
    hideTab(inputId = "tabs", target = "More")
  })

  observeEvent(input$showMenu, {
    showTab(inputId = "tabs", target = "More")
  })
}

shinyApp(ui, server)
}

}
\seealso{
\code{\link{insertTab}}
}
