% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{reactlog}
\alias{reactlog}
\alias{reactlogShow}
\alias{showReactLog}
\alias{reactlogReset}
\title{Reactive Log Visualizer}
\usage{
reactlog()

reactlogShow(time = TRUE)

showReactLog(time = TRUE)

reactlogReset()
}
\arguments{
\item{time}{A boolean that specifies whether or not to display the
time that each reactive takes to calculate a result.}
}
\description{
Provides an interactive browser-based tool for visualizing reactive
dependencies and execution in your application.
}
\details{
To use the reactive log visualizer, start with a fresh R session and
run the command \code{options(shiny.reactlog=TRUE)}; then launch your
application in the usual way (e.g. using \code{\link{runApp}}). At
any time you can hit Ctrl+F3 (or for Mac users, Command+F3) in your
web browser to launch the reactive log visualization.

The reactive log visualization only includes reactive activity up
until the time the report was loaded. If you want to see more recent
activity, refresh the browser.

Note that Shiny does not distinguish between reactive dependencies
that "belong" to one Shiny user session versus another, so the
visualization will include all reactive activity that has taken place
in the process, not just for a particular application or session.

As an alternative to pressing Ctrl/Command+F3--for example, if you
are using reactives outside of the context of a Shiny
application--you can run the \code{reactlogShow} function, which will
generate the reactive log visualization as a static HTML file and
launch it in your default browser. In this case, refreshing your
browser will not load new activity into the report; you will need to
call \code{reactlogShow()} explicitly.

For security and performance reasons, do not enable
\code{shiny.reactlog} in production environments. When the option is
enabled, it's possible for any user of your app to see at least some
of the source code of your reactive expressions and observers.
}
\section{Functions}{
\itemize{
\item \code{reactlog}: Return a list of reactive information.  Can be used in conjunction with
\code{reactlog::\link[reactlog]{reactlog_show}} to later display the reactlog graph.

\item \code{reactlogShow}: Display a full reactlog graph for all sessions.

\item \code{showReactLog}: This function is deprecated. You should use \code{\link{reactlogShow}}

\item \code{reactlogReset}: Resets the entire reactlog stack.  Useful for debugging and removing all prior reactive history.
}}

