% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/button.R
\name{action_button}
\alias{action_button}
\alias{actionButton}
\title{Action button}
\usage{
action_button(input_id, label, icon = NULL, width = NULL, ...)

actionButton(inputId, label, icon = NULL, width = NULL, ...)
}
\arguments{
\item{input_id}{The input slot that will be used to access the value.}

\item{label}{The contents of the button - a text label, but you could also use any other HTML, like an image.}

\item{icon}{An optional \link{icon} to appear on the button.}

\item{width}{The width of the input.}

\item{...}{Named attributes to be applied to the button or remaining parameters passed to button,
like \code{class}.}

\item{inputId}{the same as \code{input_id}}
}
\description{
Creates an action button whose value is initially zero, and increments by one each time it is pressed.
}
\examples{
if (interactive()){
library(shiny)
library(shiny.semantic)
ui <- shinyUI(semanticPage(
  actionButton("action_button", "Press Me!"),
  textOutput("button_output")
))
server <- function(input, output, session) {
  output$button_output <- renderText(as.character(input$action_button))
}
shinyApp(ui, server)
}

}
