% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hide.R
\name{toggle_info}
\alias{toggle_info}
\title{Toggle showing info with keyboard shortcut}
\usage{
toggle_info(shortcut = "Ctrl+Shift+K", hidden_on_start = TRUE)
}
\arguments{
\item{shortcut}{keys that trigger showing info. Shortcut can include special keys:
Ctrl, Alt, Shift. Keys should be separated with '+' sign. Default Ctrl+Shift+K}

\item{hidden_on_start}{should info panels be hidden on start of the application? Default TRUE.}
}
\value{
JS script that adds toggle functionality.
}
\description{
Toggle showing info with keyboard shortcut
}
\details{
toggle_info() should be added in the header of the application in ui.R,
 since it adds a script with toggle functionality. If you want to use it with info_value,
 you have to add outputOptions(output, [info value id], suspendWhenHidden = FALSE) to force
 rendering when the value is hidden.
}
\examples{
if (interactive()){
library(shiny)
library(shiny.info)

ui <- fluidPage(
  toggle_info(),
  shiny.info::display("test message"),
  shiny.info::info_value("test_input_value", "bottom right"),
  textInput(inputId = "test_input", label = NULL)
)

server <- function(input, output, session) {
  output$test_input_value <- shiny.info::render_info_value(input$test_input)
  outputOptions(output, "test_input_value", suspendWhenHidden = FALSE)
}

shinyApp(ui = ui, server = server)
}
}
