% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/card-tabset.R
\name{card_tabset_operate}
\alias{card_tabset_operate}
\alias{card_tabset_insert}
\alias{card_tabset_remove}
\alias{card_tabset_activate}
\title{Add, active, or remove a card within \code{\link{card_tabset}}}
\usage{
card_tabset_insert(
  inputId,
  title,
  ...,
  active = TRUE,
  notify_on_failure = TRUE,
  session = shiny::getDefaultReactiveDomain()
)

card_tabset_remove(
  inputId,
  title,
  notify_on_failure = TRUE,
  session = shiny::getDefaultReactiveDomain()
)

card_tabset_activate(
  inputId,
  title,
  notify_on_failure = TRUE,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{the element id of \code{\link{card_tabset}}}

\item{title}{the title of the card to insert, activate, or to remove}

\item{...}{the content of the card}

\item{active}{whether to set the card to be active once added}

\item{notify_on_failure}{whether to show notifications on failure}

\item{session}{shiny session domain}
}
\value{
These functions execute \code{session$sendCustomMessage} and return
whatever value generated by that function; usually nothing.
}
\description{
Add, active, or remove a card within \code{\link{card_tabset}}
}
\seealso{
\code{\link{card_tabset}}
}
