% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Baseline.R
\name{summarizeBaseline}
\alias{summarizeBaseline}
\title{Calculate BASELINe summary statistics}
\usage{
summarizeBaseline(baseline, returnType = c("baseline", "df"), nproc = 1)
}
\arguments{
\item{baseline}{\code{Baseline} object returned by \link{calcBaseline} containing 
annotations and BASELINe posterior probability density functions 
(PDFs) for each sequence.}

\item{returnType}{One of \code{c("baseline", "df")} defining whether
to return a \code{Baseline} object ("baseline") with an updated
\code{stats} slot or a data.frame ("df") of summary statistics.}

\item{nproc}{number of cores to distribute the operation over. If 
\code{nproc} = 0 then the \code{cluster} has already been
set and will not be reset.}
}
\value{
Either a modified \code{Baseline} object or data.frame containing the 
          mean BASELINe selection strength, its 95\% confidence intervals, and 
          a p-value for the presence of selection.
}
\description{
\code{summarizeBaseline} calculates BASELINe statistics such as the mean selection 
strength (mean Sigma), the 95\% confidence intervals and p-values for the presence of
selection.
}
\details{
The returned p-value can be either positive or negative. Its magnitude 
          (without the sign) should be interpreted as per normal. Its sign indicates 
          the direction of the selection detected. A positive p-value indicates positive
          selection, whereas a negative p-value indicates negative selection.
}
\examples{
\donttest{
# Subset example data
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE == "IgG")

# Collapse clones
db <- collapseClones(db, sequenceColumn="SEQUENCE_IMGT",
                     germlineColumn="GERMLINE_IMGT_D_MASK",
                     method="thresholdedFreq", minimumFrequency=0.6,
                     includeAmbiguous=FALSE, breakTiesStochastic=FALSE)
                     
# Calculate BASELINe
baseline <- calcBaseline(db, 
                         sequenceColumn="CLONAL_SEQUENCE",
                         germlineColumn="CLONAL_GERMLINE", 
                         testStatistic="focused",
                         regionDefinition=IMGT_V,
                         targetingModel=HH_S5F,
                         nproc = 1)

# Grouping the PDFs by the sample annotation
grouped <- groupBaseline(baseline, groupBy="SAMPLE")

# Get a data.frame of the summary statistics
stats <- summarizeBaseline(grouped, returnType="df")
}                     
}
\references{
\enumerate{
  \item  Uduman M, et al. Detecting selection in immunoglobulin sequences. 
           Nucleic Acids Res. 2011 39(Web Server issue):W499-504.
}
}
\seealso{
See \link{calcBaseline} for generating \code{Baseline} objects and
          \link{groupBaseline} for convolving groups of BASELINe PDFs.
}
