% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_algorithms.R
\name{GMMClustering}
\alias{GMMClustering}
\title{Model-based clustering}
\usage{
GMMClustering(xdata, nc = NULL, ...)
}
\arguments{
\item{xdata}{data matrix with observations as rows and variables as columns.}

\item{nc}{matrix of parameters controlling the number of clusters in the
underlying algorithm specified in \code{implementation}. If \code{nc} is
not provided, it is set to \code{seq(1, tau*nrow(xdata))}.}

\item{...}{additional parameters passed to \code{\link[mclust]{Mclust}}.}
}
\value{
A list with: \item{comembership}{an array of binary and symmetric
  co-membership matrices.} \item{weights}{a matrix of median weights by
  feature.}
}
\description{
Runs clustering with Gaussian Mixture Models (GMM) using implementation from
\code{\link[mclust]{Mclust}}. This function is not using stability.
}
\examples{
# Data simulation
set.seed(1)
simul <- SimulateClustering(n = c(10, 10), pk = 50)

# Clustering using Gaussian Mixture Models
mygmm <- GMMClustering(xdata = simul$data, nc = seq_len(30))
}
\seealso{
Other clustering algorithms: 
\code{\link{DBSCANClustering}()},
\code{\link{HierarchicalClustering}()},
\code{\link{KMeansClustering}()},
\code{\link{PAMClustering}()}
}
\concept{clustering algorithms}
