% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{CheckInputClustering}
\alias{CheckInputClustering}
\title{Checking input parameters (clustering)}
\usage{
CheckInputClustering(
  xdata,
  Lambda = NULL,
  pi_list = seq(0.6, 0.9, by = 0.01),
  K = 100,
  tau = 0.5,
  seed = 1,
  n_cat = 3,
  implementation = HierarchicalClustering,
  scale = TRUE,
  resampling = "subsampling",
  verbose = TRUE
)
}
\arguments{
\item{xdata}{data matrix with observations as rows and variables as columns.}

\item{Lambda}{vector of penalty parameters. Only used if
\code{implementation=HierarchicalClustering}
or\code{implementation=PAMClustering}.}

\item{K}{number of resampling iterations.}

\item{tau}{subsample size.}

\item{seed}{value of the seed to initialise the random number generator and
ensure reproducibility of the results (see \code{\link[base]{set.seed}}).}

\item{n_cat}{number of categories used to compute the stability score.
Possible values are 2 or 3.}

\item{implementation}{function to use for clustering. Possible functions
include \code{\link{HierarchicalClustering}} (hierarchical clustering),
\code{\link{PAMClustering}} (Partitioning Around Medoids),
\code{\link{KMeansClustering}} (k-means) and \code{\link{GMMClustering}}
(Gaussian Mixture Models). Alternatively, a user-defined function taking
\code{xdata} and \code{Lambda} as arguments and returning a binary and
symmetric matrix for which diagonal elements are equal to zero can be used.}

\item{scale}{logical indicating if the data should be scaled to ensure that
all variables contribute equally to the clustering of the observations.}

\item{verbose}{logical indicating if a loading bar and messages should be
printed.}
}
\description{
Checks if input parameters are valid. For invalid parameters, this function
(i) stops the run and generates an error message, or (ii) sets the invalid
parameter to its default value and reports it in a warning message.
}
\keyword{internal}
