% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{CheckInputGraphical}
\alias{CheckInputGraphical}
\title{Checking input parameters (graphical model)}
\usage{
CheckInputGraphical(
  xdata,
  pk = NULL,
  Lambda = NULL,
  lambda_other_blocks = 0.1,
  pi_list = seq(0.6, 0.9, by = 0.01),
  K = 100,
  tau = 0.5,
  seed = 1,
  n_cat = 3,
  implementation = PenalisedGraphical,
  start = "cold",
  scale = TRUE,
  resampling = "subsampling",
  PFER_method = "MB",
  PFER_thr = Inf,
  FDP_thr = Inf,
  Lambda_cardinal = 50,
  lambda_max = NULL,
  lambda_path_factor = 1e-04,
  max_density = 0.3,
  verbose = TRUE
)
}
\arguments{
\item{xdata}{data matrix with observations as rows and variables as columns.
For multi-block stability selection, the variables in data have to be
ordered by group.}

\item{pk}{optional vector encoding the grouping structure. Only used for
multi-block stability selection where \code{pk} indicates the number of
variables in each group. If \code{pk=NULL}, single-block stability
selection is performed.}

\item{Lambda}{matrix of parameters controlling the level of sparsity in the
underlying feature selection algorithm specified in \code{implementation}.
If \code{Lambda=NULL} and \code{implementation=PenalisedGraphical},
\code{\link{LambdaGridGraphical}} is used to define a relevant grid.
\code{Lambda} can be provided as a vector or a matrix with
\code{length(pk)} columns.}

\item{lambda_other_blocks}{optional vector of parameters controlling the
level of sparsity in neighbour blocks for the multi-block procedure. To use
jointly a specific set of parameters for each block,
\code{lambda_other_blocks} must be set to \code{NULL} (not recommended).
Only used for multi-block stability selection, i.e. if \code{length(pk)>1}.}

\item{pi_list}{vector of thresholds in selection proportions. If
\code{n_cat=3}, these values must be \code{>0.5} and \code{<1}. If
\code{n_cat=2}, these values must be \code{>0} and \code{<1}.}

\item{K}{number of resampling iterations.}

\item{tau}{subsample size. Only used if \code{resampling="subsampling"} and
\code{cpss=FALSE}.}

\item{seed}{value of the seed to initialise the random number generator and
ensure reproducibility of the results (see \code{\link[base]{set.seed}}).}

\item{n_cat}{number of categories used to compute the stability score.
Possible values are 2 or 3.}

\item{implementation}{function to use for graphical modelling. If
\code{implementation=PenalisedGraphical}, the algorithm implemented in
\code{\link[glassoFast]{glassoFast}} is used for regularised estimation of
a conditional independence graph. Alternatively, a user-defined function
can be provided.}

\item{start}{character string indicating if the algorithm should be
initialised at the estimated (inverse) covariance with previous penalty
parameters (\code{start="warm"}) or not (\code{start="cold"}). Using
\code{start="warm"} can speed-up the computations, but could lead to
convergence issues (in particular with small \code{Lambda_cardinal}). Only
used for \code{implementation=PenalisedGraphical} (see argument
\code{"start"} in \code{\link[glassoFast]{glassoFast}}).}

\item{scale}{logical indicating if the correlation (\code{scale=TRUE}) or
covariance (\code{scale=FALSE}) matrix should be used as input of
\code{\link[glassoFast]{glassoFast}} if
\code{implementation=PenalisedGraphical}. Otherwise, this argument must be
used in the function provided in \code{implementation}.}

\item{resampling}{resampling approach. Possible values are:
\code{"subsampling"} for sampling without replacement of a proportion
\code{tau} of the observations, or \code{"bootstrap"} for sampling with
replacement generating a resampled dataset with as many observations as in
the full sample. Alternatively, this argument can be a function to use for
resampling. This function must use arguments named \code{data} and
\code{tau} and return the IDs of observations to be included in the
resampled dataset.}

\item{PFER_method}{method used to compute the upper-bound of the expected
number of False Positives (or Per Family Error Rate, PFER). If
\code{PFER_method="MB"}, the method proposed by Meinshausen and Bühlmann
(2010) is used. If \code{PFER_method="SS"}, the method proposed by Shah and
Samworth (2013) under the assumption of unimodality is used.}

\item{PFER_thr}{threshold in PFER for constrained calibration by error
control. If \code{PFER_thr=Inf} and \code{FDP_thr=Inf}, unconstrained
calibration is used (the default).}

\item{FDP_thr}{threshold in the expected proportion of falsely selected
features (or False Discovery Proportion) for constrained calibration by
error control. If \code{PFER_thr=Inf} and \code{FDP_thr=Inf}, unconstrained
calibration is used (the default).}

\item{Lambda_cardinal}{number of values in the grid of parameters controlling
the level of sparsity in the underlying algorithm. Only used if
\code{Lambda=NULL}.}

\item{lambda_max}{optional maximum value for the grid in penalty parameters.
If \code{lambda_max=NULL}, the maximum value is set to the maximum
covariance in absolute value. Only used if
\code{implementation=PenalisedGraphical} and \code{Lambda=NULL}.}

\item{lambda_path_factor}{multiplicative factor used to define the minimum
value in the grid.}

\item{max_density}{threshold on the density. The grid is defined such that
the density of the estimated graph does not exceed max_density.}

\item{verbose}{logical indicating if a loading bar and messages should be
printed.}
}
\description{
Checks if input parameters are valid. For invalid parameters, this function
(i) stops the run and generates an error message, or (ii) sets the invalid
parameter to its default value and reports it in a warning message.
}
\keyword{internal}
