% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac.R
\name{vaeac_train_model_continue}
\alias{vaeac_train_model_continue}
\title{Continue to Train the vaeac Model}
\usage{
vaeac_train_model_continue(
  explanation,
  epochs_new,
  lr_new = NULL,
  x_train = NULL,
  save_data = FALSE,
  verbose = NULL,
  seed = 1
)
}
\arguments{
\item{explanation}{A \code{\link[=explain]{explain()}} object and \code{vaeac} must be the used approach.}

\item{epochs_new}{Positive integer. The number of extra epochs to conduct.}

\item{lr_new}{Positive numeric. If we are to overwrite the old learning rate in the adam optimizer.}

\item{x_train}{A data.table containing the training data. Categorical data must have class names \eqn{1,2,\dots,K}.}

\item{save_data}{Logical (default is \code{FALSE}). If \code{TRUE}, then the data is stored together with
the model. Useful if one are to continue to train the model later using \code{\link[=vaeac_train_model_continue]{vaeac_train_model_continue()}}.}

\item{verbose}{String vector or NULL.
Specifies the verbosity (printout detail level) through one or more of strings \code{"basic"}, \code{"progress"},
\code{"convergence"}, \code{"shapley"} and \code{"vS_details"}.
\code{"basic"} (default) displays basic information about the computation which is being performed,
in addition to some messages about parameters being sets or checks being unavailable due to specific input.
\verb{"progress} displays information about where in the calculation process the function currently is.
#' \code{"convergence"} displays information on how close to convergence the Shapley value estimates are
(only when \code{iterative = TRUE}) .
\code{"shapley"} displays intermediate Shapley value estimates and standard deviations (only when \code{iterative = TRUE})
and the final estimates.
\code{"vS_details"} displays information about the v_S estimates.
This is most relevant for \verb{approach \%in\% c("regression_separate", "regression_surrogate", "vaeac"}).
\code{NULL} means no printout.
Note that any combination of four strings can be used.
E.g. \code{verbose = c("basic", "vS_details")} will display basic information + details about the v(S)-estimation process.}

\item{seed}{Positive integer (default is \code{1}). Seed for reproducibility. Specifies the seed before any randomness
based code is being run.}
}
\value{
A list containing the training/validation errors and paths to where the vaeac models are saved on the disk.
}
\description{
Function that loads a previously trained vaeac model and continue the training, either
on new data or on the same dataset as it was trained on before. If we are given a new dataset, then
we assume that new dataset has the same distribution and one_hot_max_sizes as the original dataset.
}
\references{
\itemize{
\item \href{https://www.jmlr.org/papers/volume23/21-1413/21-1413.pdf}{
Olsen, L. H., Glad, I. K., Jullum, M., & Aas, K. (2022). Using Shapley values and variational autoencoders to
explain predictive models with dependent mixed features. Journal of machine learning research, 23(213), 1-51}
}
}
\author{
Lars Henry Berge Olsen
}
