% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{make_dummies}
\alias{make_dummies}
\title{Initiate the making of dummy variables}
\usage{
make_dummies(traindata, testdata)
}
\arguments{
\item{traindata}{data.table or data.frame.}

\item{testdata}{data.table or data.frame. New data that has the same
feature names, types, and levels as \code{traindata}.}
}
\value{
A list that contains the following entries:
\describe{
\item{feature_list}{List. Output from \code{check_features}}
\item{train_dummies}{A data.frame containing all of the factors in \code{traindata} as
one-hot encoded variables.}
\item{test_dummies}{A data.frame containing all of the factors in \code{testdata} as
one-hot encoded variables.}
\item{traindata_new}{Original traindata with correct column ordering and factor levels. To be passed to
\code{\link[shapr:shapr]{shapr}.}}
\item{testdata_new}{Original testdata with correct column ordering and factor levels. To be passed to
\code{\link[shapr:explain]{explain}.}}
}
}
\description{
Initiate the making of dummy variables
}
\examples{
if (requireNamespace("MASS", quietly = TRUE)) {
  data("Boston", package = "MASS")
  x_var <- c("lstat", "rm", "dis", "indus")
  y_var <- "medv"
  x_train <- as.data.frame(Boston[401:411, x_var])
  y_train <- Boston[401:408, y_var]
  x_test <- as.data.frame(Boston[1:4, x_var])

  # convert to factors for illustational purpose
  x_train$rm <- factor(round(x_train$rm))
  x_test$rm <- factor(round(x_test$rm), levels = levels(x_train$rm))

  dummylist <- make_dummies(traindata = x_train, testdata = x_test)
}
}
\author{
Annabelle Redelmeier, Martin Jullum
}
