% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.shapr}
\alias{plot.shapr}
\title{Plot of the Shapley value explanations}
\usage{
\method{plot}{shapr}(
  x,
  digits = 3,
  plot_phi0 = TRUE,
  index_x_test = NULL,
  top_k_features = NULL,
  ...
)
}
\arguments{
\item{x}{An \code{shapr} object. See \code{\link{explain}}.}

\item{digits}{Integer. Number of significant digits to use in the feature description}

\item{plot_phi0}{Logical. Whether to include \code{phi0} in the plot}

\item{index_x_test}{Integer vector. Which of the test observations to plot. E.g. if you have
explained 10 observations using \code{\link{explain}}, you can generate a plot for the first 5
observations by setting \code{index_x_test = 1:5}.}

\item{top_k_features}{Integer. How many features to include in the plot. E.g. if you have 15
features in your model you can plot the 5 most important features, for each explanation, by setting
\code{top_k_features = 1:5}.}

\item{...}{Currently not used.}
}
\value{
ggplot object with plots of the Shapley value explanations
}
\description{
Plots the individual prediction explanations.
}
\details{
See \code{vignette("understanding_shapr", package = "shapr")} for an example of
how you should use the function.
}
\examples{
#' # Load example data
data("Boston", package = "MASS")

# Split data into test- and training data
x_train <- head(Boston, -3)
x_test <- tail(Boston, 3)

# Fit a linear model
model <- lm(medv ~ lstat + rm + dis + indus, data = x_train)

# Create an explainer object
explainer <- shapr(x_train, model)

# Explain predictions
p <- mean(x_train$medv)

# Empirical approach
explanation <- explain(x_test,
                      explainer,
                      approach = "empirical",
                      prediction_zero = p,
                      n_samples = 1e2)

# Plot the explantion (this function)
plot(explanation)

}
\author{
Martin Jullum
}
