% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgnht.R
\name{sgnhtSetup}
\alias{sgnhtSetup}
\title{Create an sgnht object}
\usage{
sgnhtSetup(logLik, dataset, params, stepsize, logPrior = NULL,
  minibatchSize = 0.01, a = 0.01, seed = NULL)
}
\arguments{
\item{logLik}{function which takes parameters and dataset 
(list of TensorFlow variables and placeholders respectively) as input. 
It should return a TensorFlow expression which defines the log likelihood of the model.}

\item{dataset}{list of numeric R arrays which defines the datasets for the problem.
The names in the list should correspond to those referred to in the logLik and logPrior functions}

\item{params}{list of numeric R arrays which define the starting point of each parameter.
The names in the list should correspond to those referred to in the logLik and logPrior functions}

\item{stepsize}{list of numeric values corresponding to the SGLD stepsizes for each parameter
The names in the list should correspond to those in params.
Alternatively specify a single numeric value to use that stepsize for all parameters.}

\item{logPrior}{optional. Default uninformative improper prior.
Function which takes parameters (list of TensorFlow variables) as input.
The function should return a TensorFlow tensor which defines the log prior of the model.}

\item{minibatchSize}{optional. Default 0.01.
Numeric or integer value that specifies amount of dataset to use at each iteration 
either as proportion of dataset size (if between 0 and 1) or actual magnitude (if an integer).}

\item{a}{optional. Default 0.01. List of numeric values corresponding to SGNHT diffusion factors
(see Algorithm 2 of the original paper). One value should be given 
for each parameter in params, the names should correspond to those in params.
Alternatively specify a single float to specify that value for all parameters.}

\item{seed}{optional. Default NULL. Numeric seed for random number generation. The default
does not declare a seed for the TensorFlow session.}
}
\value{
The function returns an 'sgnht' object, which is used to pass the required information
 about the current model to the \code{\link{sgmcmcStep}} function. The function 
 \code{\link{sgmcmcStep}} runs one step of sgnht. The sgnht object has the following attributes:
\describe{
\item{params}{list of tf$Variables with the same names as the params list passed to
 \code{\link{sgnhtSetup}}. This is the object passed to the logLik and logPrior functions you
 declared to calculate the log posterior gradient estimate.}
\item{estLogPost}{a tensor that estimates the log posterior given the current 
 placeholders and params.}
\item{N}{dataset size.}
\item{data}{dataset as passed to \code{\link{sgnhtSetup}}.}
\item{n}{minibatchSize as passed to \code{\link{sgnhtSetup}}.}
\item{placeholders}{list of tf$placeholder objects with the same names as dataset
 used to feed minibatches of data to \code{\link{sgmcmcStep}}. This object
 gets fed to the dataset argument of the logLik and logPrior functions you declared.}
\item{stepsize}{list of stepsizes as passed to \code{\link{sgnhtSetup}}.}
\item{a}{list of a tuning parameters as passed to \code{\link{sgnhtSetup}}.}
\item{dynamics}{a list of TensorFlow steps that are evaluated by \code{\link{sgmcmcStep}}.}}
}
\description{
Creates an sgnht (stochastic gradient Nose Hoover Thermostat) object which can be passed to 
 \code{\link{sgmcmcStep}} to simulate from 1 step of SGNHT for the posterior defined by 
 logLik and logPrior. This allows the user to code the loop themselves, as in many standard 
 TensorFlow procedures (such as optimization). Which means they do not need to store 
 the chain at each iteration. This is useful when the full chain needs a lot of memory.
}
\examples{
\dontrun{
# Simulate from a Normal Distribution, unknown location and known scale with uninformative prior
# Run sgmcmc step by step and calculate estimate of location on the fly to reduce storage
dataset = list("x" = rnorm(1000))
params = list("theta" = 0)
logLik = function(params, dataset) {
    distn = tf$contrib$distributions$Normal(params$theta, 1)
    return(tf$reduce_sum(distn$log_prob(dataset$x)))
}
stepsize = list("theta" = 1e-4)
sgnht = sgnhtSetup(logLik, dataset, params, stepsize)
nIters = 10^4L
# Initialize location estimate
locEstimate = 0
# Initialise TensorFlow session
sess = initSess(sgnht)
for ( i in 1:nIters ) {
    sgmcmcStep(sgnht, sess)
    locEstimate = locEstimate + 1 / nIters * getParams(sgnht, sess)$theta
}
# For more examples see vignettes
}
}
