% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc.R
\name{sfc_multilinestring}
\alias{sfc_multilinestring}
\title{sfc MULTILINESTRING}
\usage{
sfc_multilinestring(obj = NULL, x = NULL, y = NULL, z = NULL,
  m = NULL, multilinestring_id = NULL, linestring_id = NULL)
}
\arguments{
\item{obj}{sorted matrix or data.frame}

\item{x}{x geometry column}

\item{y}{y geometry column}

\item{z}{z geometry column}

\item{m}{m geometry column}

\item{multilinestring_id}{column of ids for multilinestrings}

\item{linestring_id}{column of ids for linestrings (within multilinestrings)}
}
\value{
\code{sfc} object of MULTILINESTRING geometries
}
\description{
constructs an sfc of MULTILINESTRING objects
}
\section{notes}{

sfheaders functions do not perform any validity checks on the geometries.
Nor do they set Coordinate Reference Systems, EPSG, PROJ4 or precision attributes.

The data.frame and matrices you send into the sfheader functions must be ordered.
}

\examples{

m <- matrix(c(0,0,0,0,1,1), ncol = 3 )
sfc_multilinestring( m )

m <- matrix(c(0,0,0,0,0,1,0,1,1,1,2,2,1,2,3), ncol = 3, byrow = TRUE)
sfc_multilinestring( obj = m )
sfc_multilinestring( obj = m, multilinestring_id = 1 )
sfc_multilinestring( obj = m, linestring_id = 1 )

sfc_multilinestring( obj = m, linestring_id = 1, multilinestring_id = 1 )

sfc_multilinestring( obj = m, x = 2, y = 3 )
sfc_multilinestring( obj = m, x = 1, y = 2, z = 3 )
sfc_multilinestring( obj = m, x = 2, y = 3, linestring_id = 1, multilinestring_id = 1 )

df <- data.frame(
  ml_id = c(1,1,1,1,1,1,1,1,2,2,2,2,2)
  , l_id = c(1,1,1,2,2,3,3,3,1,1,1,2,2)
  , x = rnorm(13)
  , y = rnorm(13)
  , z = rnorm(13)
  , m = rnorm(13)
)

sfc_multilinestring( obj = df, x = "x", y = "y")
sfc_multilinestring( obj = df, x = "x", y = "y", z = "z")
sfc_multilinestring( obj = df, x = "x", y = "y", z = "z", m = "m")

sfc_multilinestring( obj = df, x = 2, y = 3)
sfc_multilinestring( obj = df, x = 2, y = 3, z = 4)
sfc_multilinestring( obj = df, x = 2, y = 3, z = 4, m = 5)

sfc_multilinestring( obj = df, multilinestring_id = "ml_id", linestring_id = "l_id" )
sfc_multilinestring( obj = df, multilinestring_id = 1, linestring_id = 2 )



}
