% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-tasks.R
\name{Tasks}
\alias{Tasks}
\title{R6 Class representing tasks endpoints}
\description{
R6 Class representing tasks resource endpoints.
}
\examples{

## ------------------------------------------------
## Method `Tasks$bulk_get`
## ------------------------------------------------

\dontrun{
 # Get details of multiple tasks
 a$tasks$bulk_get(
               tasks = list("task_1_ID", "task_2_ID")
              )
}

}
\section{Super class}{
\code{\link[sevenbridges2:Resource]{sevenbridges2::Resource}} -> \code{Tasks}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Tasks-new}{\code{Tasks$new()}}
\item \href{#method-Tasks-query}{\code{Tasks$query()}}
\item \href{#method-Tasks-get}{\code{Tasks$get()}}
\item \href{#method-Tasks-delete}{\code{Tasks$delete()}}
\item \href{#method-Tasks-create}{\code{Tasks$create()}}
\item \href{#method-Tasks-bulk_get}{\code{Tasks$bulk_get()}}
\item \href{#method-Tasks-clone}{\code{Tasks$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tasks-new"></a>}}
\if{latex}{\out{\hypertarget{method-Tasks-new}{}}}
\subsection{Method \code{new()}}{
Create new Tasks resource object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tasks$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tasks-query"></a>}}
\if{latex}{\out{\hypertarget{method-Tasks-query}{}}}
\subsection{Method \code{query()}}{
This call lists all tasks you can access. \cr \cr
Read more about how to use query parameters properly
\href{https://docs.sevenbridges.com/reference/list-tasks-you-can-access}{here}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tasks$query(
  status = NULL,
  parent = NULL,
  project = NULL,
  created_from = NULL,
  created_to = NULL,
  started_from = NULL,
  started_to = NULL,
  ended_from = NULL,
  ended_to = NULL,
  order_by = c("created_time", "start_time", "name", "end_time", "created_by"),
  order = c("asc", "desc"),
  origin_id = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{You can filter the returned tasks by their status.
Set the value of status to one of the following values: \code{QUEUED},
\code{DRAFT}, \code{RUNNING}, \code{COMPLETED}, \code{ABORTED}, \code{FAILED}.}

\item{\code{parent}}{Provide task ID or Task object of the parent task to return
all child tasks from that parent. A parent task is a task that specifies
criteria by which to batch its inputs into a series of further
sub-tasks, called child tasks. See the documentation on
\href{https://docs.sevenbridges.com/docs/about-batch-analyses}{batching tasks}
for more details on how to run tasks in batches.}

\item{\code{project}}{Provide the project ID or Project object you wish to list
the tasks from.}

\item{\code{created_from}}{Enter the starting date string for querying tasks
created on the specified date and onwards.}

\item{\code{created_to}}{Enter the ending date string for querying tasks
created until the specified date. You can use it in combination with
\code{created_from} to specify a time interval.}

\item{\code{started_from}}{Enter the starting date string for querying tasks
started on the specified date and onwards.}

\item{\code{started_to}}{Enter the ending date string for querying tasks
started until the specified date.}

\item{\code{ended_from}}{Enter the starting date string for querying tasks
that ended on a specified date.}

\item{\code{ended_to}}{Enter the ending date string for querying tasks that
ended until a specified date.}

\item{\code{order_by}}{Order returned results by the specified field.
Allowed values: \cr \code{created_time}, \code{start_time}, \code{name}, \code{end_time} and
\code{created_by}. \cr Sort can be done only by one column. The default
value is \code{created_time}.}

\item{\code{order}}{Sort results in ascending or descending order by
specifying \code{asc} or \code{desc}, respectively. Only taken into account if
\code{order_by} is explicitly specified. The default value is \code{asc}.}

\item{\code{origin_id}}{Enter an automation run ID to list all tasks
created from the specified automation run.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{Task}} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tasks-get"></a>}}
\if{latex}{\out{\hypertarget{method-Tasks-get}{}}}
\subsection{Method \code{get()}}{
This call returns details of the specified task. The task
is referred to by its ID, which you can obtain by making the call to
list all tasks you can access. The task details include its creator, its
start and end time, the number of jobs completed in it, and its input
and output files. You can also see the status of the task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tasks$get(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The ID of the task you are querying.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Task}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tasks-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Tasks-delete}{}}}
\subsection{Method \code{delete()}}{
This call deletes a task from the Seven Bridges Platform.
Tasks are specified by their IDs, which you can obtain by using
\code{Tasks$query()} to list tasks or by getting a single task
using \code{Tasks$get()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tasks$delete(task, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\code{\link{Task}} object or task ID.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
as 'fields', etc.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tasks-create"></a>}}
\if{latex}{\out{\hypertarget{method-Tasks-create}{}}}
\subsection{Method \code{create()}}{
This call creates a new task. You can create either a single
task or a batch task by using the app's default batching, override
batching, or disable batching completely. A parent task is a task that
specifies criteria by which to batch its inputs into a series of further
sub-tasks, called child tasks. the documentation on
\href{https://docs.sevenbridges.com/docs/about-batch-analyses}{batching tasks}
for more details on batching criteria.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tasks$create(
  project,
  app,
  revision = NULL,
  name = NULL,
  description = NULL,
  execution_settings = NULL,
  inputs = NULL,
  output_location = NULL,
  batch = NULL,
  batch_input = NULL,
  batch_by = NULL,
  use_interruptible_instances = NULL,
  action = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{project}}{The ID of a project or a Project object where you
want to create the task in.}

\item{\code{app}}{The ID of an app or an App object you want to run.
Recall that apps are specified by their projects, in the form
\verb{<project_id>/<app_name>}.}

\item{\code{revision}}{The app
\href{https://docs.sevenbridges.com/docs/app-versions}{revision (version)}
number.}

\item{\code{name}}{The name of the task.}

\item{\code{description}}{An optional description of the task.}

\item{\code{execution_settings}}{Named list with detailed task execution
parameters. Detailed task execution parameters:
\itemize{
\item \code{instance_type}: Possible value is the specific instance type,
e.g. \code{"instance_type" = "c4.2xlarge;ebs-gp2;2000"};
\item \code{max_parallel_instances}: Maximum number of instances
running at the same time. Takes any integer value equal to or
greater than 1, e.g. \code{"max_parallel_instances" = 2.};
\item \code{use_memoization}: Set to \code{FALSE} by default. Set to \code{TRUE}
to enable
\href{https://docs.sevenbridges.com/docs/about-memoization}{memoization};
\item \code{use_elastic_disk}: Set to \code{TRUE} to enable
\href{https://docs.sevenbridges.com/page/elastic-disk}{Elastic Disk}.
}

Here is an example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{execution_settings <- list(
  "instance_type" = "c4.2xlarge;ebs-gp2;2000",
  "max_parallel_instances" = 2,
  "use_memoization" = TRUE,
  "use_elastic_disk" = TRUE
  )
}\if{html}{\out{</div>}}}

\item{\code{inputs}}{List of objects. See the section on
\href{https://docs.sevenbridges.com/docs/the-api#section-inputs}{specifying task inputs}
for information on creating task input objects. Here is an example with
various input types:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{inputs <- list(
  "input_file"= "<file_id/file_object>",
  "input_directory" = "<folder_id/folder_object>",
  "input_array_string" = list("<string_elem_1>", "<string_elem_2>"),
  "input_boolean" = TRUE,
  "input_double" = 54.6,
  "input_enum" = "enum_1",
  "input_float" = 11.2,
  "input_integer" = "asdf",
  "input_long" = 4212,
  "input_string" = "test_string",
  "input_record" = list(
    "input_record_field_file" = "<file_id/file_object>",
    "input_record_field_integer" = 42
   )
  )
}\if{html}{\out{</div>}}}

\item{\code{output_location}}{The output location list allows you to
define the exact location where your task outputs will be stored.
The location can either be defined for the entire project using the
main_location parameter, or individually per each output node, by
setting the nodes_override parameter to true and defining individual
output node locations within nodes_location.
See below for more details.
\itemize{
\item \code{main_location} - Defines the output location for all
output nodes in the task. Can be a string path within the project in
which the task is created, for example \cr
\verb{/Analysis/<task_id>_<task_name>/} \cr
or a path on an attached volume, such as \cr
\verb{volumes://volume_name/<project_id>/html}. \cr
Parts of the path enclosed in angle brackets <> are tokens that are
dynamically replaced with corresponding values during task
execution.
\item \code{main_location_alias}: The string location (path) in the
project that will point to the actual location where the outputs are
stored. Used if main_location is defined as a volume path (starting
with volumes://), to provide an easy way of accessing output data
directly from project files.
\item \code{nodes_override}: Enables defining of output locations
for output nodes individually through nodes_location (see below).
Set to \code{TRUE} to be able to define individual locations per output
node. Default: \code{FALSE}.
Even if nodes_override is set to \code{TRUE}, it is not necessary to
define output locations for each of the output nodes individually.
Data from those output nodes that don't have their locations
explicitly defined through nodes_location is either placed in
main_location (if defined) or at the project files root if a main
output location is not defined for the task.
\item \code{nodes_location}: List of output paths for individual
task output nodes in the following format for each output node:\cr
\verb{<output-node-id> = list(} \cr
\verb{"output_location" = "<output-path>",} \cr
\code{"output_location_alias" = "<alias-path>"} \cr
\verb{)} \cr
Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{b64html = list(
 "output_location" = "volumes://outputs/tasks/mar-19",
 "output_location_alias" = "/rfranklin/tasks/picard"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{ In the example above, b64html is the ID of the output node for which
 you want to define the output location, while the parameters are
 defined as follows:
}\if{html}{\out{</div>}}

\itemize{
\item \code{output_location} - Can be a path within the project in which
the task is created, for example
\verb{/Analysis/<task_id>_<task_name>/}
or a path on an attached volume, such as
\verb{volumes://volume_name/<project_id>/html}. Also accepts tokens.
\item \code{output_location_alias} - The location (path) in the project
that will point to the exact location where the output is stored.
Used if output_location is defined as a volume path
(starting with volumes://).
}
}}

\item{\code{batch}}{This is set to \code{FALSE} by default. Set to \code{TRUE} to
create a batch task and specify the \code{batch_input} and \code{batch-by}
criteria as described below.}

\item{\code{batch_input}}{The ID of the input on which you wish to batch.
You would typically batch on the input consisting of a list of files.
If this parameter is omitted, the default batching criteria defined for
the app will be used.}

\item{\code{batch_by}}{Batching criteria in form of list. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{batch_by = list(
  type = "CRITERIA",
  criteria = list("metadata.condition")
)
}\if{html}{\out{</div>}}}

\item{\code{use_interruptible_instances}}{This field can be \code{TRUE} or \code{FALSE}.
Set this field to \code{TRUE} to allow the use of
\href{https://docs.sevenbridges.com/docs/about-spot-instances}{spot instances}.}

\item{\code{action}}{If set to \code{run}, the task will be run immediately upon
creation.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Task}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tasks-bulk_get"></a>}}
\if{latex}{\out{\hypertarget{method-Tasks-bulk_get}{}}}
\subsection{Method \code{bulk_get()}}{
This call returns statistics for all specified tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tasks$bulk_get(tasks)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tasks}}{A list of \code{\link{Task}} objects or list of strings
(IDs) of the tasks you are requesting the statistics for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} (list of \code{\link{Task}} objects).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Get details of multiple tasks
 a$tasks$bulk_get(
               tasks = list("task_1_ID", "task_2_ID")
              )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tasks-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Tasks-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tasks$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
