% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testMultiset}
\alias{testMultiset}
\alias{checkMultiset}
\alias{assertMultiset}
\title{assert/check/test/Multiset}
\usage{
testMultiset(object, errormsg = "This is not an R6 Multiset object")

checkMultiset(object, errormsg = "This is not an R6 Multiset object")

assertMultiset(object, errormsg = "This is not an R6 Multiset object")
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is an R6 \code{Multiset}.
}
\examples{
testMultiset(Set$new(2, 3))
testMultiset(list(Set$new(2), Set$new(3)))
testMultiset(Tuple$new(2, 3))
testMultiset(Interval$new())
testMultiset(FuzzySet$new(2, 0.1))
testMultiset(FuzzyTuple$new(2, 0.1))
testMultiset(ConditionalSet$new(function(x) x == 0))
}
