% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_variables.R
\name{summaryStops}
\alias{summaryStops}
\title{Summarize the number and length of stops}
\usage{
summaryStops(list, summary.df = NA, stop.threshold = 0)
}
\arguments{
\item{list}{A list of data frames, each of which must have a column recording
the velocity variable.}

\item{summary.df}{The data frame object within which you are storing path
summary variables. The default is NA if you do not currently have a summary
data frame object started. When set to \code{NA} the function will create a
new summary data frame. When an object is provided, the function will merge
the summary data frame with the new data.}

\item{stop.threshold}{The velocity below which the insect is considered to be
stopped. The default is 0, but should be adjusted based on observations of
the insect and the recording equipment.}
}
\description{
Caulculate how many times an insect stopped walking during its recorded
movement and the average length of those stops.
}
\details{
This function evaluates a path for the total number of stops made during the
recording, as well as the average length of those stops. The function
requires the user to provide a movement threshold, below which the insect is
considered to be stopped. The servosphere may record small movements of
insect appendages or side to side motion as movement but typically this will
be much slower than actual movement. Estimates of this threshold speed can be
obtained by comparing recordings of the data to videos of the actual movement
or in person observation.
}
