% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serp.performance.R
\name{errorMetrics}
\alias{errorMetrics}
\title{Performance metrics for categorical models}
\usage{
errorMetrics(
             actual,
             predicted,
             model= c("multiclass", "binary"),
             type= c("brier", "logloss", "misclass"),
             eps=.Machine$double.eps)
}
\arguments{
\item{actual}{vector of actual values observed}

\item{predicted}{predicted probability matrix of a categorical model or a
vector of fitted values for binary models.}

\item{model}{specifies whether multi-categorical or binary model}

\item{type}{specifies type of error metrics}

\item{eps}{a near-zero value introduced only if the fitted probabilities go
beyond a specified threshold. It helps to minimize the chances of running
into numerical problems.}
}
\value{
A numeric value of computed performance metric determining how
good a categorical model is compare to competing models.
\describe{
  \item{brier}{the brier score of fitted model.}
  \item{logloss}{the logloss of fitted model.}
  \item{misclass}{the misclassification error of fitted model.}
}
}
\description{
Calculates performance metrics of fitted categorical models,
including binary and multi-categorical models.
}
\examples{

f1 <- serp(rating ~ temp + contact, tuneMethod = "user",
slope = "penalize", lambda = 0.3, reverse = TRUE, link = "logit",
data = wine)
errorMetrics(f1, type = "brier")
errorMetrics(f1, type = "logloss")
errorMetrics(f1, type = "misclass")

## For non-serp object of class, 'actual'  and 'predicted' values
## must be provided
set.seed(1)
y <- as.factor(rbinom(50,1,0.5))
xx <- runif(50)
f2 <- glm(y ~ xx, family = binomial(link="logit"))
p2 <- f2$fitted.values

errorMetrics(actual=y, predicted=p2, model= "binary", type = "brier")
errorMetrics(actual=y, predicted=p2, model= "binary", type = "logloss")
errorMetrics(actual=y, predicted=p2, model= "binary", type = "misclass")

}
\seealso{
\code{\link{serp}}
}
