% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.summary.seroincidence.by.R
\name{autoplot.summary.seroincidence.by}
\alias{autoplot.summary.seroincidence.by}
\title{Plot method for \code{summary.seroincidence.by} objects}
\usage{
\method{autoplot}{summary.seroincidence.by}(object, type, ...)
}
\arguments{
\item{object}{a \code{summary.seroincidence.by} object
(generated by applying the \code{summary()}
method to the output of \code{\link[=est_seroincidence_by]{est_seroincidence_by()}}).}

\item{type}{\link{character} string indicating which type of plot to generate.
The implemented options are:
\itemize{
\item \code{"scatter"}: calls \code{\link[=strat_ests_scatterplot]{strat_ests_scatterplot()}} to generate a scatterplot
\item \code{"bar"}: calls \code{strat_ests_barplot()} to generate a barplot
}}

\item{...}{
  Arguments passed on to \code{\link[=strat_ests_scatterplot]{strat_ests_scatterplot}}, \code{\link[=strat_ests_barplot]{strat_ests_barplot}}
  \describe{
    \item{\code{xvar}}{the name of a stratifying variable in \code{object}}
    \item{\code{alpha}}{transparency for the points in the graph
(1 = no transparency, 0 = fully transparent)}
    \item{\code{shape}}{shape argument for \code{geom_point()}}
    \item{\code{dodge_width}}{width for jitter}
    \item{\code{CIs}}{\link{logical}, if \code{TRUE}, add CI error bars}
    \item{\code{color_var}}{\link{character} which variable in \code{object} to use
to determine point color}
    \item{\code{group_var}}{\link{character} which variable in \code{object} to use
to connect points with lines (\code{NULL} for no lines)}
    \item{\code{yvar}}{the name of a stratifying variable in \code{object}.}
    \item{\code{title}}{a title for the final plot.}
    \item{\code{xlab}}{a label for the x-axis of the final plot.}
    \item{\code{ylab}}{a label for the y-axis of the final plot.}
    \item{\code{fill_lab}}{fill label.}
    \item{\code{color_palette}}{optional color palette for bar color.}
  }}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
Plot method for \code{summary.seroincidence.by} objects
}
\examples{

library(dplyr)
library(ggplot2)

xs_data <-
  sees_pop_data_pk_100

curve <-
  typhoid_curves_nostrat_100 \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

noise <-
  example_noise_params_pk

est2 <- est_seroincidence_by(
  strata = c("catchment", "ageCat"),
  pop_data = xs_data,
  sr_params = curve,
  noise_params = noise,
  curve_strata_varnames= NULL,
  noise_strata_varnames = NULL,
  antigen_isos = c("HlyE_IgG", "HlyE_IgA"),
  num_cores = 2 # Allow for parallel processing to decrease run time
)

est2sum <- summary(est2)

est2sum |> autoplot(
    type ="scatter",
    xvar = "ageCat",
    color_var = "catchment",
    CIs = TRUE,
    group_var = "catchment")

est2sum |> autoplot(
    type = "bar",
    yvar = "ageCat",
    color_var = "catchment",
    CIs = TRUE)

}
