% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_umap.R
\name{register_umap}
\alias{register_umap}
\alias{umap}
\title{Register Seriation Based on 1D UMAP}
\usage{
register_umap()
}
\value{
Nothing.
}
\description{
Use uniform manifold approximation and projection (UMAP) to embed the data
on the number line and create a order for \code{\link[=seriate]{seriate()}}.
}
\details{
Registers the method \code{"umap"} for \code{\link[=seriate]{seriate()}}. This method applies
1D UMAP to data represented by a distance matrix and extracts the order from
the 1D embedding.

\bold{Note:} Package \pkg{umap} needs to be installed.
}
\examples{

\dontrun{
register_umap()
get_seriation_method("dist", "umap")

d <- dist(random.robinson(50, pre=TRUE, noise=.1))

o <- seriate(d, method = "umap")
pimage(d, o)
}

}
\references{
McInnes, L, Healy, J, UMAP: Uniform Manifold Approximation and
Projection for Dimension Reduction, ArXiv e-prints 1802.03426, 2018
}
\seealso{
\code{\link[umap:umap]{umap::umap()}} in \pkg{umap}.

Other seriation: 
\code{\link{register_DendSer}()},
\code{\link{register_GA}()},
\code{\link{register_optics}()},
\code{\link{register_tsne}()},
\code{\link{registry_seriate}},
\code{\link{seriate}()}
}
\concept{seriation}
\keyword{cluster}
\keyword{optimize}
