% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CountGenerations.R
\name{getGenerations}
\alias{getGenerations}
\title{Count Generations}
\usage{
getGenerations(Ped, StopIfInvalid = TRUE)
}
\arguments{
\item{Ped}{dataframe, pedigree with the first three columns being id - dam -
sire. Column names are ignored, as are additional columns.}

\item{StopIfInvalid}{if a pedigree loop is detected, stop with an error
(TRUE, default) or return the Pedigree, to see where the problem(s) occur.}
}
\value{
A vector with the generation number for each individual, starting at
  0 for founders. NA indicates a pedigree loop where an individual is its own
  ancestor (or that the pedigree has >1000 generations). Returned invisibly
  to be a part of QC.
}
\description{
For each individual in a pedigree, count the number of
  generations since its most distant pedigree founder.
}
