% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missings_generation.R
\name{seqaddNA}
\alias{seqaddNA}
\title{Generation of missing on longitudinal categorical data.}
\usage{
seqaddNA(
  data,
  var = NULL,
  states.high = NULL,
  propdata = 1,
  pstart.high = 0.1,
  pstart.low = 0.005,
  maxgap = 3,
  only.traj = FALSE
)
}
\arguments{
\item{data}{a data frame containing sequences of a multinomial 
variable with missing data (coded as \code{NA})}

\item{var}{the list of columns containing the trajectories. 
Default is \code{NULL}, i.e. all the columns.}

\item{states.high}{list of states that have a larger probability of 
triggering a subsequent missing data gap}

\item{propdata}{proportion  observations for which missing data is simulated}

\item{pstart.high}{probability to start a missing data for the 
states specified with the \code{states.high} argument}

\item{pstart.low}{probability to start a missing data for the 
other states}

\item{maxgap}{maximum length of a missing data gap}

\item{only.traj}{logical that specifies whether only the trajectories should 
be returned (\code{only.traj=TRUE}), or 
the whole data (\code{only.traj=FALSE})}
}
\value{
Returns a data frame on which missing data were simulated
}
\description{
Generation of missing data under the form of gaps, which
is the typical form of missing data with longitudinal data.
It simulates MCAR or MAR missing data.
}
\examples{
# Generate MCAR missing data on the mvad dataset 
# from the TraMineR package

\dontrun{
data(mvad, package = "TraMineR")
mvad.miss <- seqaddNA(mvad, var = 17:86)


# Generate missing data on mvad where joblessness is more likely to trigger 
# a missing data gap
mvad.miss2 <- seqaddNA(mvad, var = 17:86,  states.high = "joblessness")
}

}
\author{
Kevin Emery
}
