% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_data_cat.R
\name{update_data_cat}
\alias{update_data_cat}
\title{Add the new sample into labeled dataset from unlabeled dataset for the
  categorical case}
\usage{
update_data_cat(ind, splitted, data, train, labeled_ids, unlabeled_ids)
}
\arguments{
\item{ind}{A numeric value denotes the index of selected sample.}

\item{splitted}{A list containing the datasets which we will use in the
categorical case. Note that the element of the splitted is the collections
of samples from Classes 0 and Classes k.}

\item{data}{A matrix  denotes all the data including the labeled samples and
the unlabeled samples. Note that the first column of the dataset is the
response variable, that's the labels and the rest is the explanatory
variables.}

\item{train}{A matrix for the labeled samples.}

\item{labeled_ids}{A numeric vector for the unique identification of the
labeled dataset}

\item{unlabeled_ids}{A numeric vector for the unique identification of the
unlabeled dataset}
}
\value{
\item{splitted}{a list containing the datasets which we add a new sample into
it}
\item{newY}{the label of the choosed sample}
\item{train}{the dataset used for training the model after adding the new
sample}
\item{labeled_ids}{the id of the labeled dataset after updating}
\item{unlabeled_ids}{the id of the unlabeled dataset after updating}
}
\description{
\code{update_data_cat} selects the sample to the labeled dataset according to
it's index
}
\details{
update_data_cat chooses the sample based on the index from all the training
dataset if the data has no ordinal relation.  Specifically, we remove the
index of the choosed sample from the unlabeled dataset and add the index to
the labeled dataset. Then, combine the selected sample with the existing
training data set.
}
\examples{
## For an example, see example(seq_cat_model)
}
\references{
{
Li, J., Chen, Z., Wang, Z., & Chang, Y. I. (2020). Active learning in
multiple-class classification problems via individualized binary models.
\emph{Computational Statistics & Data Analysis}, 145, 106911.
doi:10.1016/j.csda.2020.106911
}
}
\seealso{
{
   \code{\link{update_data_ord}}

}
}
