\name{enzCut}
\alias{enzCut}
\title{
Restriction enzyme cutting pattern
}
\description{
Function for calculating Restriction enzyme cutting pattern
}
\usage{
enzCut(DNAsq, enznames, enzdata = enzdata)
}
\arguments{
  \item{DNAsq}{
The input fasta data.
}
  \item{enznames}{
A character vector of the restriction enzyme's names, from one to multiple names. 
}
  \item{enzdata}{
Dataframe with first column for enzyme names, second column for enzyme cutting patterns.
}
}
\details{
Users could add restriction sites manually according to the enzdata styles.
}
\value{

  \item{enz }{The selected restriction enzyme.}
  \item{RFLP.site }{The sites recognized by enzyme. }
  \item{RFLP.frag }{The fragments generated by enzyme cutting.}
  \item{TRFLP }{The fragments predicted by TRFLP}
  
}
\references{
None.
}
\author{
Qiong Ding \email{dingqiong1@gmail.com}
}

\seealso{
See Also \code{\link{frag.dat}}
}
\examples{

## enzCut() example
data(enzdata)
enznames <- c("EcoRI", "Acc65I")
data(fil.phy)
fas <- ConvFas(fil = fil.phy, type = "phy")
enzCut(DNAsq = fas[2], enznames = "AluI", enzdata = enzdata)

}

\keyword{ RFLP }
\keyword{ TRFLP}
