\name{VEpowerPP}
\alias{VEpowerPP}
\title{
Power to Detect Positive Treatment Efficacy in a Per-Protocol Cohort
}
\description{
\code{VEpowerPP} computes power to detect positive treatment (vaccine) efficacy in per-protocol cohorts identified in \code{simTrial}-generated data-sets.
}
\usage{
VEpowerPP(dataList, VEcutoffWeek, stage1, alpha, outName = NULL, 
          saveDir = NULL)
}
\arguments{
  \item{dataList}{if \code{saveDir = NULL}, a list of objects returned by \code{simTrial}; otherwise a list of \code{.RData} file names (character strings) generated by \code{simTrial}}
  \item{VEcutoffWeek}{a cut-off time (in weeks). Only subjects with the follow-up time exceeding \code{VEcutoffWeek} are included in the per-protocol cohort.}
  \item{stage1}{the final week of stage 1 in a two-stage trial. The VE(post-\code{VEcutoffWeek}--\code{stage1}) estimand is considered in the power calculation.}
  \item{alpha}{the nominal significance level of the one-sided test of the null hypothesis that VE(post-\code{VEcutoffWeek}--\code{stage1}) \eqn{\le} 0\%}
  \item{outName}{a character string specifying the output \code{.RData} file name. If \code{outName = NULL} but \code{saveDir} is specified, the output file is named \code{VEpwPP.RData}.}
  \item{saveDir}{a character string specifying a path for the output directory. If supplied, the output is saved as an \code{.RData} file named \code{outName} in the directory; otherwise the output is returned as a list.}  
}
\details{
All time variables use week as the unit of time. Month is defined as 52/12 weeks.

A per-protocol cohort indicator is assumed to be included in the \code{simTrial}-generated data-sets, which is ensured by specifying the \code{missVaccProb} argument in \code{simTrial}.

VE(post-\code{VEcutoffWeek}--\code{stage1}) is estimated as one minus the ratio of Nelson-Aalen-based cumulative incidence functions. \code{VEpowerPP} computes power to reject the null hypothesis H0: VE(post-\code{VEcutoffWeek}--\code{stage1}) \eqn{\le} 0\% using the one-sided Nelson-Aalen cumulative hazard-based Wald test at the \code{alpha} level of significance.
}
\value{
If \code{saveDir} is specified, the output list (named \code{pwList}) is saved as an \code{.RData} file named \code{outName} (or \code{VEpwPP.RData} if left unspecified); otherwise the output list is returned. The output object is a list (of equal length as \code{dataList}) of lists with the following components:
\item{VE}{a numeric vector of VE(post-\code{VEcutoffWeek}--\code{stage1}) estimates for each missing vaccination probability in \code{missVaccProb} of \code{simTrial}}
\item{VEpwPP}{a numeric vector of powers to reject the null hypothesis H0: VE(post-\code{VEcutoffWeek}--\code{stage1}) \eqn{\le} 0\% for each missing vaccination probability in \code{missVaccProb} of \code{simTrial}}
}
\seealso{
\code{\link{simTrial}}
}
\examples{
simData <- simTrial(N=rep(1000, 2), aveVE=c(0, 0.4), VEmodel="half", 
                    vePeriods=c(1, 27, 79), enrollPeriod=78, 
                    enrollPartial=13, enrollPartialRelRate=0.5, dropoutRate=0.05, 
                    infecRate=0.04, fuTime=156, 
                    visitSchedule=c(0, (13/3)*(1:4), seq(13*6/3, 156, by=13*2/3)),
                    missVaccProb=c(0,0.05,0.1,0.15), VEcutoffWeek=26, nTrials=30, 
                    stage1=78, randomSeed=300)
                    
VEpwPP <- VEpowerPP(dataList=list(simData), VEcutoffWeek=26, stage1=78, 
                    alpha=0.025)

### alternatively, to save the .RData output file (no '<-' needed):
###
### simTrial(N=rep(1000, 2), aveVE=c(0, 0.4), VEmodel="half", 
###          vePeriods=c(1, 27, 79), enrollPeriod=78, enrollPartial=13, 
###          enrollPartialRelRate=0.5, dropoutRate=0.05, infecRate=0.04, fuTime=156, 
###          visitSchedule=c(0, (13/3)*(1:4), seq(13*6/3, 156, by=13*2/3)), 
###          missVaccProb=c(0,0.05,0.1,0.15), VEcutoffWeek=26, nTrials=30, 
###          stage1=78, saveDir="./", randomSeed=300)
###
### VEpowerPP(dataList=
###           list("simTrial_nPlac=1000_nVacc=1000_aveVE=0.4_infRate=0.04.RData"),
###           VEcutoffWeek=26, stage1=78, alpha=0.025, saveDir="./")
}
