% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentometrics.R
\docType{data}
\name{list_valence_shifters}
\alias{list_valence_shifters}
\title{Built-in valence word lists}
\format{A \code{list} with all built-in valence word lists, appropriately named.}
\source{
\code{\link[lexicon]{hash_valence_shifters}} (English valence shifters)
}
\usage{
data("list_valence_shifters")
}
\description{
A \code{list} containing all built-in valence word lists, a \code{data.table} with three columns: a \code{x} column with the
words, a \code{t} column with the type of valence words, and a \code{y} column with the values associated to each word and
type of valence shifter. The \code{list} element names indicate the language (based on the two-letter ISO code
convention as in \code{\link[stopwords]{stopwords}}) of the valence word list. All non-English word lists
are translated via Microsoft Translator through Microsoft Word. Only the entries whose translation differs from
the original entry are kept. The valence word lists are in the form required for further sentiment analysis. All words
are in lowercase. The built-in valence word lists are available in following languages:

\itemize{
  \item English (\code{"en"})
  \item French (\code{"fr"})
  \item Dutch (\code{"nl"})
}
}
\details{
The \code{t} column is coded as follows: \code{1} for negators, \code{2} for amplifiers/intensifiers, and
\code{3} for deamplifiers/downtoners. Default scores are -1, 2, and 0.5 respectively. See
\code{\link{setup_lexicons}} for details about the application of the valence shifters to the lexicons,
and along the same vein, to the corpus.
}
\examples{
data("list_valence_shifters", package = "sentometrics")
list_valence_shifters["en"]

}
\keyword{datasets}
