% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{select_measures}
\alias{select_measures}
\title{Select sentiment measures}
\usage{
select_measures(sentomeasures, toSelect, do.combine = TRUE)
}
\arguments{
\item{sentomeasures}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{toSelect}{a \code{character} vector of the lexicon, feature and time weighting scheme names, to indicate which
measures need to be selected. One can also supply a \code{list} of such \code{character} vectors, in which case
\code{do.combine = TRUE} is set automatically, such that the separately specified combinations are selected.}

\item{do.combine}{a \code{logical} indicating if only measures for which all (\code{do.combine = TRUE}) or at least one
(\code{do.combine = FALSE}) of the selection components should occur in each sentiment measure's name in the selection. If
\code{do.combine = TRUE}, the \code{toSelect} argument can only consist of one lexicon, one feature, and one time weighting
scheme at maximum.}
}
\value{
A modified \code{sentomeasures} object, with only the sentiment measures required, including updated information
and statistics, but the original sentiment scores \code{data.table} untouched.
}
\description{
Selects all sentiment measures which include either all of the given selection components combined,
or those who's name consist of at least one of the selection components.
}
\examples{
data("usnews", package = "sentometrics")
data("lexicons", package = "sentometrics")
data("valence", package = "sentometrics")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- setup_lexicons(lexicons[c("LM_eng", "HENRY_eng")], valence[["valence_eng"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# different selections
sel1 <- select_measures(sentomeasures, c("equal_weight"))
sel2 <- select_measures(sentomeasures, c("equal_weight", "linear"), do.combine = FALSE)
sel3 <- select_measures(sentomeasures, c("linear", "LM_eng"))
sel4 <- select_measures(sentomeasures, list(c("linear", "wsj"), c("linear", "economy")))

}
\author{
Samuel Borms
}
