% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen2r_process_report.R
\name{sen2r_process_report}
\alias{sen2r_process_report}
\title{Summarise processing report}
\usage{
sen2r_process_report(
  s2_list_ordered,
  s2names = NULL,
  pm = NULL,
  ignorelist = list(),
  s2_list_cloudcovered = NA,
  s2_list_failed = NA,
  download_only = FALSE,
  s2_downloaded = NA,
  s2_skipped = NA,
  s2_corrected = NA
)
}
\arguments{
\item{s2_list_ordered}{List containing the lists of ordered/notordered LTA
S2 images.}

\item{s2names}{Output of \code{\link[=compute_s2_paths]{compute_s2_paths()}}.}

\item{pm}{List containing sen2r processing parameters.}

\item{ignorelist}{Internal parameter.}

\item{s2_list_cloudcovered}{Internal parameter.}

\item{s2_list_failed}{Internal parameter.}

\item{download_only}{Logical: if TRUE, it indicates that the processing to be
summarised only involved download (\code{pm$preprocess = FALSE}).}

\item{s2_downloaded}{Internal parameter.}

\item{s2_skipped}{Internal parameter.}

\item{s2_corrected}{Internal parameter.}
}
\value{
A data.frame summarising the report, and containing the following columns:
\itemize{
\item \code{time}: date/time of report creation;
\item \code{n_req_tot_dates}: number of dates to be processed based on the query;
\item \code{n_ondisk_dates}: number of dates for which all expected products are
already on disk;
\item \code{n_proc_dates}: number of date for which some products were computed in
the current run;
\item \code{n_complete_out}: number of dates for which processing is "complete",
and all products were created;
\item \code{n_failed_dates}: number of dates for which processing is "complete",
but some products were not created for unexpected reasons;
\item \code{n_cloudy_dates}: number of dates for which processing is "complete",
but some products were not created because cloudiness in the spatial
extent was above \code{max_mask};
\item \code{n_notonline_dates}: number of date for which processing is "incomplete",
because not all require images are online;
\item \code{n_ordered_imgs}: number of images correctly ordered from LTA;
\item \code{n_notordered_imgs}: number of images for which LTA order failed;
\item \code{n_downloaded}: number of images downloaded during current run;
\item \code{n_skipped}: number of required images not downloaded because already
on disk
(note: this does not include images that would be needed to process
a date for which all products are already on disk);
\item \code{n_corrected}: number of images atmospherically corrected using sen2cor;
\item \code{completed}: logical, indicating if processing can be considered
"complete" (it is set to TRUE in case \code{n_notonline_dates = 0}).
}
}
\description{
Internal function used to summarise results of sen2r execution
at the end of a processing..
}
\note{
License: GPL 3.0
}
\author{
Lorenzo Busetto, phD (2020) \email{lbusett@gmail.com}
}
