% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_factor_point_to.R
\name{auto_factor_point_to}
\alias{auto_factor_point_to}
\title{Create a Matrix for
'factor_point_to'}
\usage{
auto_factor_point_to(factor_layout, ...)
}
\arguments{
\item{factor_layout}{Argument description.}

\item{...}{Additional arguments. If
the first argument is not named, then
it should be a named vector of
directions, names being the names of
the factors, and directions can be
one of these values: \code{"up"}, \code{"down"},
\code{"left"}, \code{"right"}. Other arguments
are ignored. If the arguments are named,
then the names of the arguments are
the names of the factors, and the
argument values are the direction for
the factors.}
}
\value{
A character matrix of the same
dimension as \code{factor_layout}. The
cells of factor names are replaced
by the directions to place their
indicators.
}
\description{
Use a named vector or
named arguments to create a matrix
of the directions of indicators of
factors.
}
\details{
A helper function to make
it easier to create the matrix
used by \code{\link[=set_sem_layout]{set_sem_layout()}} to
indicate where the indicators of
each factor should be positioned.

It works in two modes. If the
first argument is a named vector,
such as \code{c(f1 = "up", f2 = "down")},
then this vector will be used to
create the direction matrix.

If the arguments are named, such as
\verb{auto_factor_point_to(factor_layout, f1 = "up", f2 = "down"},
then the names are treated as the
factor names, and the values of
the arguments are treated as the
directions.

The matrix created can then be used
for the argument \code{factor_point_to}
in \code{\link[=set_sem_layout]{set_sem_layout()}}.
}
\examples{
factor_layout <- matrix(c("f1",   NA,   NA,
                            NA, "f3", "f4",
                          "f2",   NA,   NA), byrow = TRUE, 3, 3)
factor_point_to <- auto_factor_point_to(factor_layout,
                                        f1 = "left",
                                        f2 = "left",
                                        f3 = "down",
                                        f4 = "down")
factor_point_to
}
\seealso{
\code{\link[=set_sem_layout]{set_sem_layout()}}
}
