% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semmcci-mc.R
\name{MC}
\alias{MC}
\title{Monte Carlo Confidence Intervals}
\usage{
MC(object, R = 20000L, alpha = c(0.001, 0.01, 0.05))
}
\arguments{
\item{object}{object of class \code{lavaan}.}

\item{R}{Positive integer.
Number of Monte Carlo replications.}

\item{alpha}{Numeric vector.
Significance level.
Default value is \code{alpha = c(0.001, 0.01, 0.05)}.}
}
\value{
Returns an object of class \code{semmcci} which is a list with the following elements:
\itemize{
\item{\code{lavaan}}{\code{lavaan} object.}
\item{\code{mu}}{Mean vector used in the Monte Carlo simulation.}
\item{\code{Sigma}}{Variance-covariance matrix used in the Monte Carlo simulation.}
\item{\code{thetahat}}{Parameter estimates.}
\item{\code{thetahatstar}}{Sampling distribution of parameter estimates.}
\item{\code{ci}}{Confidence intervals.}
}
The list element \code{ci} is a matrix with the following columns:
\itemize{
\item{\code{est}}{Parameter estimates.}
\item{\code{se}}{Standard errors or the square root of the diagonals of the Monte Carlo sampling distribution of parameter estimates.}
\item{\code{R}}{Number of Monte Carlo replications.}
\item{...}{Percentiles that correspond to the confidence intervals defined by \code{alpha}.}
}
Note that the rows in \code{ci} correspond to the model parameters.
Parameters with zero standard errors and constant confidence limits are fixed parameters.
}
\description{
Calculates Monte Carlo confidence intervals
for free and defined parameters
}
\details{
A sampling distribution of parameter estimates is generated
from the multivariate normal distribution
using the parameter estimates and the sampling variance-covariance matrix.
Confidence intervals for free and defined parameters
are generated using the simulated sampling distribution.
Parameters can be defined using the \verb{:=} operator
in the \code{lavaan} model syntax.
}
\examples{
library(semmcci)
library(lavaan)

# Generate Data ------------------------------------------------------------
n <- 1000
x <- rnorm(n = n)
m <- 0.50 * x + rnorm(n = n)
y <- 0.25 * x + 0.50 * m + rnorm(n = n)
data <- data.frame(x, m, y)

# Fit Model in lavaan ------------------------------------------------------
model <- "
  y ~ cp * x + b * m
  m ~ a * x
  ab := a * b
"
fit <- sem(data = data, model = model)

# Monte Carlo --------------------------------------------------------------
MC(
  fit,
  R = 100L, # use a large value e.g., 20000L for actual research
  alpha = c(0.001, 0.01, 0.05)
)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{mc}
