% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_interactions.R
\name{product_indicator}
\alias{product_indicator}
\title{\code{product_indicator} creates interaction measurement items by scaled product indicator approach.}
\usage{
# standardized product indicator approach as per Henseler & Chin (2010):
 product_indicator(iv, moderator, weights)
}
\arguments{
\item{iv}{The independent variable that is subject to moderation.}

\item{moderator}{The moderator variable.}

\item{weights}{is the relationship between the items and the interaction terms. This can be
specified as \code{correlation_weights} or \code{mode_A} for correlation weights (Mode A) or as
\code{regression_weights} or \code{mode_B} for regression weights (Mode B). Default is correlation weights.}
}
\description{
This function automatically generates interaction measurement items for a PLS SEM using scaled product indicator approach.
}
\examples{
data(mobi)

# seminr syntax for creating measurement model
mobi_mm <- constructs(
 composite("Image",        multi_items("IMAG", 1:5),weights = mode_A),
 composite("Expectation",  multi_items("CUEX", 1:3),weights = mode_A),
 composite("Value",        multi_items("PERV", 1:2),weights = mode_A),
 composite("Satisfaction", multi_items("CUSA", 1:3),weights = mode_A),
 interaction_term(iv = "Image",
                  moderator = "Expectation",
                  method = product_indicator,
                  weights = mode_A),
 interaction_term(iv = "Image",
                  moderator = "Value",
                  method = product_indicator,
                  weights = mode_A)
)

# structural model: note that name of the interactions construct should be
#  the names of its two main constructs joined by a '*' in between.
mobi_sm <- relationships(
  paths(to = "Satisfaction",
        from = c("Image", "Expectation", "Value",
                "Image*Expectation", "Image*Value"))
)

# Load data, assemble model, and estimate using semPLS
mobi <- mobi
seminr_model <- estimate_pls(mobi, mobi_mm, mobi_sm, inner_weights = path_factorial)

}
\references{
Henseler & Chin (2010), A comparison of approaches for the analysis of interaction effects
between latent variables using partial least squares path modeling. Structural Equation Modeling, 17(1),82-109.
}
