% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dot.R
\name{dot_graph}
\alias{dot_graph}
\alias{dot_graph.cfa_model}
\alias{dot_graph.cbsem_model}
\alias{dot_graph.measurement_model}
\alias{dot_graph.structural_model}
\alias{dot_graph.specified_model}
\alias{dot_graph.boot_seminr_model}
\alias{dot_graph.pls_model}
\title{Generate a dot graph from various SEMinR models}
\usage{
dot_graph(model, title = "", theme = NULL, ...)

\method{dot_graph}{cfa_model}(
  model,
  title = "",
  theme = NULL,
  what = "std",
  whatLabels = "std",
  ...
)

\method{dot_graph}{cbsem_model}(
  model,
  title = "",
  theme = NULL,
  what = "std",
  whatLabels = "std",
  ...
)

\method{dot_graph}{measurement_model}(model, title = "", theme = NULL, ...)

\method{dot_graph}{structural_model}(model, title = "", theme = NULL, ...)

\method{dot_graph}{specified_model}(
  model,
  title = "",
  theme = NULL,
  measurement_only = FALSE,
  structure_only = FALSE,
  ...
)

\method{dot_graph}{boot_seminr_model}(
  model,
  title = "",
  theme = NULL,
  measurement_only = FALSE,
  structure_only = FALSE,
  ...
)

\method{dot_graph}{pls_model}(
  model,
  title = "",
  theme = NULL,
  measurement_only = FALSE,
  structure_only = FALSE,
  ...
)
}
\arguments{
\item{model}{Model created with \code{seminr}.}

\item{title}{An optional title for the plot}

\item{theme}{Theme created with \code{\link{seminr_theme_create}}.}

\item{...}{Unused}

\item{what}{The metric to use for edges ("path", "est", "std", "eq", "col")}

\item{whatLabels}{The metric to use for edge labels}

\item{measurement_only}{Plot only measurement part}

\item{structure_only}{Plot only structure part}
}
\value{
The path model as a formatted string in dot language.
}
\description{
With the help of the \code{DiagrammeR} package this dot graph can then be plotted in
various in RMarkdown, shiny, and other contexts.
Depending on the type of model, different parameters can be used.

For a full description of parameters for lavaan models see \link[semPlot]{semPaths}
}
\details{
Current limitations:
- Only plots PLS Models
- no higher order constructs
}
\examples{
mobi <- mobi

#seminr syntax for creating measurement model
mobi_mm <- constructs(
             reflective("Image",        multi_items("IMAG", 1:5)),
             reflective("Expectation",  multi_items("CUEX", 1:3)),
             reflective("Quality",      multi_items("PERQ", 1:7)),
             reflective("Value",        multi_items("PERV", 1:2)),
             reflective("Satisfaction", multi_items("CUSA", 1:3)),
             reflective("Complaints",   single_item("CUSCO")),
             reflective("Loyalty",      multi_items("CUSL", 1:3))
           )
#seminr syntax for creating structural model
mobi_sm <- relationships(
  paths(from = "Image",        to = c("Expectation", "Satisfaction", "Loyalty")),
  paths(from = "Expectation",  to = c("Quality", "Value", "Satisfaction")),
  paths(from = "Quality",      to = c("Value", "Satisfaction")),
  paths(from = "Value",        to = c("Satisfaction")),
  paths(from = "Satisfaction", to = c("Complaints", "Loyalty")),
  paths(from = "Complaints",   to = "Loyalty")
)

mobi_pls <- estimate_pls(data = mobi,
                         measurement_model = mobi_mm,
                         structural_model = mobi_sm)

# adapt nboot for better results
mobi_boot <- bootstrap_model(mobi_pls, nboot = 20, cores = 1)
# generate dot-Notation
res <- dot_graph(mobi_pls, title = "PLS-Model plot")

\dontrun{
DiagrammeR::grViz(res)}

# generate dot-Notation
res <- dot_graph(mobi_boot, title = "Bootstrapped PLS-Model plot")

\dontrun{
DiagrammeR::grViz(res)}

# - - - - - - - - - - - - - - - -
# Example for plotting a measurement model
mobi_mm <- constructs(
             reflective("Image",        multi_items("IMAG", 1:5)),
             reflective("Expectation",  multi_items("CUEX", 1:3)),
             reflective("Quality",      multi_items("PERQ", 1:7)),
             reflective("Value",        multi_items("PERV", 1:2)),
             reflective("Satisfaction", multi_items("CUSA", 1:3)),
             reflective("Complaints",   single_item("CUSCO")),
             reflective("Loyalty",      multi_items("CUSL", 1:3))
           )
dot_graph(mobi_mm, title = "Preview measurement model")
# - - - - - - - - - - - - - - - -
# Example for plotting a structural model
mobi_sm <- relationships(
  paths(from = "Image",        to = c("Expectation", "Satisfaction", "Loyalty")),
  paths(from = "Expectation",  to = c("Quality", "Value", "Satisfaction")),
  paths(from = "Quality",      to = c("Value", "Satisfaction")),
  paths(from = "Value",        to = c("Satisfaction")),
  paths(from = "Satisfaction", to = c("Complaints", "Loyalty")),
  paths(from = "Complaints",   to = "Loyalty")
)
res <- dot_graph(mobi_sm, title = "Preview structural model")

\dontrun{
DiagrammeR::grViz(res)
}
}
